/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef COMMENTVIEW_H
#define COMMENTVIEW_H

#include "view.h"

class QTextEdit;

/**
* View for adding comments to issues.
*/
class CommentView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    CommentView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~CommentView();

public: // overrides
    void initialUpdate();

    bool queryClose();

protected: // overrides
    void enableView();
    void disableView();

    void updateEvent( UpdateEvent* e );

private slots:
    void updateActions();
    void updateClipboard();
    void updateSummary();

    void sendComment();

    void sendCompleted( bool successful );

    void contextMenu( const QPoint& pos );

private:
    Access checkDataAccess();

    void updateCaption();

    bool issueAutoNotify();

private:
    QTextEdit* m_edit;

    bool m_sending;

    int m_folderId;
};

#endif
