/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef UPDATEBATCH_H
#define UPDATEBATCH_H

#include <QList>

#include "commands/abstractbatch.h"
#include "updateevent.h"

/**
* Batch for retrieving data from the server.
*/
class UpdateBatch : public AbstractBatch
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param priority Priority of the batch.
    */
    UpdateBatch( int priority = -5 );

    /**
    * Destructor.
    */
    ~UpdateBatch();

public:
    /**
    * Add a <tt>LIST USERS</tt> command to the batch.
    */
    void updateUsers();

    /**
    * Add a <tt>LIST TYPES</tt> command to the batch.
    */
    void updateTypes();

    /**
    * Add a <tt>LIST PROJECTS</tt> command to the batch.
    */
    void updateProjects();

    /**
    * Add a <tt>LIST ISSUES</tt> command to the batch.
    *
    * @param folderId Identifier of the folder to update.
    */
    void updateFolder( int folderId );

    /**
    * Add a <tt>GET DETAILS</tt> command to the batch.
    *
    * @param issueId Identifier of the issue to update.
    */
    void updateIssue( int issueId );

    /**
    * Add a <tt>LIST PREFERENCES</tt> command to the batch.
    */
    void updatePreferences();

    /**
    * Add a <tt>LIST NOTIFICATIONS</tt> command to the batch.
    */
    void updateNotifications();

    /**
    * If set to @c true, only update folders/issues when they are out of date.
    */
    void setIfNeeded( bool value );

    /**
    * Return @c true if folders/issues are updated only when they are out of date.
    */
    bool ifNeeded() const { return m_ifNeeded; }

public: // overrides
    Command* fetchNext();

private:
    struct Unit
    {
        Unit()
        {
        }

        Unit( UpdateEvent::Unit unit, int id = 0 ) :
            m_unit( unit ),
            m_id( id )
        {
        }

        UpdateEvent::Unit m_unit;
        int m_id;
    };

    QList<Unit> m_units;
    int m_next;

    bool m_ifNeeded;
};

#endif
