/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H

#include "commanddialog.h"

class QCheckBox;
class QLineEdit;

namespace WebIssues
{

class Bookmark;

/**
* Dialog for logging in to the server.
*/
class LoginDialog : public CommandDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    LoginDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~LoginDialog();

public:
    /**
    * Load settings from given bookmark.
    */
    void loadBookmark( const Bookmark& bookmark, bool editable );

    /**
    * Create a bookmark for current connection.
    */
    Bookmark createBookmark();

protected: // overrides
    void accept();

    bool batchSuccessful( AbstractBatch* batch );

private:
    QLineEdit* m_urlEdit;
    QLineEdit* m_loginEdit;
    QLineEdit* m_passwordEdit;

    QCheckBox* m_rememberCheck;

    bool m_successful;
};

}

#endif
