#include "DefaultSchedulingManager.h"
#include "warped/TimeWarpSimulationManager.h"
#include "warped/Event.h"

// Copyright (c) 2003 Clifton Labs, Inc.  All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com

DefaultSchedulingManager::DefaultSchedulingManager( TimeWarpSimulationManager *initSimulationManager ) 
  : mySimulationManager( initSimulationManager ),
    lastScheduledTime( initSimulationManager->getZero().clone() ){}

DefaultSchedulingManager::~DefaultSchedulingManager(){}

const Event *
DefaultSchedulingManager::peekNextEvent(){
  TimeWarpEventSet *eventSet = mySimulationManager->getEventSetManager();
  ASSERT( eventSet != 0 );
  vector<string> *localObjects = mySimulationManager->getSimulationObjectNames();
  ASSERT( localObjects != 0 );

  const Event *earliestEvent = 0;
  for( vector<string>::iterator i = localObjects->begin();
       i < localObjects->end();
       i++ ){
    const Event *tempEvent = eventSet->peekEvent( mySimulationManager->getObjectHandle( (*i) ) );
    if( earliestEvent == 0 ||
	( tempEvent != 0 && 
	  tempEvent->getReceiveTime() < earliestEvent->getReceiveTime() )){
      earliestEvent = tempEvent;      
    }
  }
  delete localObjects;

  if( earliestEvent != 0 ){
    setLastScheduledEventTime( earliestEvent->getReceiveTime() );
  }

  return earliestEvent;
}

void
DefaultSchedulingManager::setLastScheduledEventTime( const VTime &newTime ){
  delete lastScheduledTime;
  lastScheduledTime = newTime.clone();
}


const VTime &
DefaultSchedulingManager::getLastEventScheduledTime(){
  ASSERT( lastScheduledTime != 0 );
  return *lastScheduledTime;
}
