/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "file.h"

@implementation File

+ alloc
{
    self = [super alloc];
    return self;
}

- initWithFile: (File*) file
{
	_file = ([[NSString alloc] initWithString: [file name]]);
	_link = ([[NSString alloc] initWithString: [file link]]);
	_remotepath =([[NSString alloc] initWithString: [file remotepath]]);
	_localpath = ([[NSString alloc] initWithString: [file localpath]]);
	_currentsize = [file currentsize];
	_size = [file size];
	_state = [file isCurrent];
	_error = NO;
	_id = [file getID];
	return self;
}

- initWithName: (NSString*) name withSize: (long int) size withType: (int) type {
    return [self initWithName: name withSize: size withType: type withLink: @""]; 
}
- initWithName: (NSString*) name withSize: (long int) size withType: (int) type withLink: (NSString*) link {
    _file = [[NSString alloc] initWithString: name];
    _link = [[NSString alloc] initWithString: link];
    _localpath = [[NSString alloc] initWithString: @""];
    _remotepath = [[NSString alloc] initWithString: @""];
    _currentsize = 0;
    _size = size;
    _type = type;
    _state = NO;
    _error = NO;
    _id = 0;
    return self;
}

- (long int) getID { return _id; }
- (void) setID: (long int) mid { _id = mid; }
- (NSString*) name { return _file; }
- (NSString*) link { return _link; }
- (NSString*) remotepath { return _remotepath; }
- (NSString*) localpath { return _localpath; }
- (void) setLocalPath: (NSString*) localpath {_localpath = ([[NSString alloc] initWithString: localpath]);}
- (void) setRemotePath: (NSString*) remotepath {_remotepath = ([[NSString alloc] initWithString: remotepath]);}
- (long int) currentsize { return _currentsize; }
- (NSString*) printcurrentsize { return [NSString stringWithFormat: @"%i", _currentsize]; }
- (long int) size { return _size; }
- (NSString*) printsize { return [NSString stringWithFormat: @"%i", _size]; }

- addToSize : (long int) size {
	_currentsize += size;
}
- (double) getAdvance {
return ((double) _currentsize / (double) _size ) * 100;
}
- (NSString*) getStatus {
	NSMutableString* ret = [[NSMutableString alloc] autorelease];

	if (_error)
	{
	    [ret appendString: @"FTP Error"];
	}
	else if (_currentsize == 0)
	{
		[ret appendString: @"Waiting..."];
	}
	else if (_currentsize < _size )
	{
		float percentage = ((float) _currentsize / (float) _size ) * 100;
		[ret appendFormat: @"%.2f ", percentage];
	}
	else if (_currentsize == _size)
	{
		[ret appendString: @"Done."];
	}
	else if (_currentsize > _size)
	{
		[ret appendFormat: @"ERROR ! (%d > %d)", _currentsize, _size];
	}
		
	return ret;
}
- (void) setDone {
    _done = YES;
}
- (void) setCurrent: (BOOL) state {
    _state = state;
}
- (void) setError {
    _error = YES;
    _state = NO;
}
- (BOOL) isCurrent {
    return _state;
}
- (BOOL) isDone {
	BOOL ret = NO;
	if (_done) ret = YES;
	if (_error) ret = YES;
	return ret;
}
- (BOOL) isDir {
	BOOL ret = NO;
	if (_type == 1) ret = YES;
	return ret;
}
- (BOOL) isLink {
	BOOL ret = NO;
	if (_type == 2) ret = YES;
	return ret;
}
- (void) print {
    //NSLog (@"[%] \"%@\" (%i/%i) ==> %@", _type, _file, _currentsize, _size, _link);
}

@end
