/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "FTPBrowser.h"
#import "waiho.h"

@implementation GestFTPBrowser : NSObject

- (id) init {
	self = [super init];
	files = nil;
	return self;
}

- (int)browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column {
	NSString *ptc = [sender pathToColumn: column];
	int ret = 0;
	int i = 0;
	
	//NSLog (@"On entre dans browser:numberOfRowsInColumn:(%d)",column);

	if ([[(MyDelegate*)[NSApp delegate] ftp] isConnected])
	{
		NSLog (@"On fait un ls sur >%@<", ptc);
		files = [[[NSApp delegate] ftp] list: ptc];

		NSLog (@" files == %d ", files);
		ret = (int) [files count];
		//NSLog (@" FTP connecte : %i on a %i fichiers\n", [[[NSApp delegate] ftp] isConnected], ret);
	}
	//NSLog (@"On quitte browser:numberOfRowsInColumn:(%d)", column);

	if ((column > 0) && (![[(MyDelegate*)[NSApp delegate] ftp] isConnected]))
	{
	    //[[NSDistributedNotificationCenter defaultCenter] postNotificationName:
		//@"RemoteDisconnected" object: @"RemoteBrowser"];
		[[NSRunLoop currentRunLoop] performSelector: @selector(disconnectRemote:)
			target: [NSApp delegate] argument: nil order: 50000 modes: [NSArray arrayWithObject: NSDefaultRunLoopMode]];
	}
	
	return ret;
}
- (void)browser:(NSBrowser *)sender willDisplayCell:(id)cell atRow:(int)row column:(int)column {
	NSString *ptc = [sender pathToColumn: column];
	int count = 0;
	BOOL exists = NO, is_dir = NO;
	


	//NSLog (@"On entre dans browser:willDisplayCell:atRow:(%d)column:(%d)",row,column);

	if ([[[NSApp delegate] ftp] isConnected])
	{
		if (files != nil)
		{
			count = [files count];
			if (row >= count)
			return;

			if ([[files objectAtIndex: row] isDir]) [cell setLeaf: NO];
			else [cell setLeaf: YES];

			[cell setStringValue: [(File*)[files objectAtIndex: row] name]];
			[cell setFile: [files objectAtIndex: row]];
			if ([[files objectAtIndex: row] isLink])
			{
			    [cell setFont: [[NSFontManager sharedFontManager] 
			    convertFont: [NSFont systemFontOfSize: [NSFont systemFontSize]] 
			    toHaveTrait: NSItalicFontMask]];
			}
		}	
	}
	//NSLog (@"On quitte browser:willDisplayCell:atRow:(%d)column:(%d)",row, column);
}
- (NSString *)browser:(NSBrowser *)sender titleOfColumn:(int)column {
	return [sender pathToColumn: column];
}
- (NSArray*) files {
	return files;
}

@end

