// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        plainfile.h
// 
// Purpose:     
// 
// Created:     4 May 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#ifndef hg_utils_plainfile_h
#define hg_utils_plainfile_h

#include "file.h"

// the user should get the flags along 
#include "hgunistd.h"
#include <fcntl.h> 

// for off_t
#include <sys/types.h>


// <class> 
//  
// Name:             PlainFile
// 
// Purpose:          
// 
// Public Interface: 
// 
// Description:      self explanatory (?)
// 
// $Id: plainfile.h,v 1.7 1997/01/29 15:02:20 gorasche Exp $
//
// $Log: plainfile.h,v $
// Revision 1.7  1997/01/29 15:02:20  gorasche
// derived classes for Win32
//
// Revision 1.6  1996/10/03 15:59:07  jfasch
// adaptions due to moving it from the previous location in DcCommon to HgUtilities
//
// Revision 1.5  1996/07/22 08:18:19  jfasch
// *** empty log message ***
//
// Revision 1.4  1996/05/14 09:35:29  jfasch
// changed File to read DcFile because of namespace issues
//
// Revision 1.3  1996/02/21 14:32:54  jfasch
// due to changes to class File had to remove set_close_() and get_close_().
//
// Revision 1.2  1995/12/27 14:25:38  jfasch
// - RCSified
//
//
// </class> 
class PlainFile : public HgFile {
public:
   PlainFile() ;
   PlainFile (int fd) ;
   PlainFile (const char* path, int flags, int mode=0666) ;
   virtual ~PlainFile() ;
   
   boolean open (const char* path, int flags, int mode=0666) ;
   boolean sync() ;
   boolean trunc (off_t) ;
   off_t seek (off_t offset, int whence=SEEK_SET) ;
// gorasche 150796 NT needs other commands on sockets
#ifdef WIN32
   int write (const char* buf, int nbytes) ;
   int read (char* buf, int nbytes) ;
#endif

private:
   PlainFile (const PlainFile&) {}
   PlainFile& operator=(const PlainFile&) { return *this; }
public:
   static const char* version1 ;
} ;
static const char* hg_utils_plainfile_version = PlainFile::version1 ;

SmartPtrdeclare (PlainFilePtr, PlainFile) 



#endif
