#ifndef IMAGES_H
#define IMAGES_H


/* we only deal with 8 bits RGB images */
#define IMAGE_BW    1
#define IMAGE_BWA   2
#define IMAGE_RGB   3
#define IMAGE_RGBA  4

#define IMAGE_FIX   0
#define IMAGE_ANIM  1

#define INTERP_NORM_BITS  8
#define INTERP_NORM       (1 << INTERP_NORM_BITS)
#define INTERP_NORM1_BITS 16
#define INTERP_NORM1      (1 << INTERP_NORM_BITS)

#define EXT_GIF		"gif"
#define EXT_JPEG	"jpeg"
#define EXT_PNG		"png"
#define EXT_PPM		"ppm"
#define EXT_PCX		"pcx"
#define EXT_PHP		"phtml"
#define EXT_JPG		"jpg"
#define EXT_RGB		"rgb"
#define EXT_RGBA	"rgba"
#define EXT_BW		"bw"
#define EXT_LA		"la"
#define EXT_VRE		"vre"
#define EXT_MD2		"md2"
#define EXT_TXF		"txf"

#define MIME_GIF	"gif"
#define MIME_JPEG	"jpeg"
#define MIME_PNG	"png"
#define MIME_PPM	"x-portable-pixmap"
#define MIME_PCX	"x-pcx"
#define MIME_PHP	"x-php"
#define MIME_RGB	"x-rgb"
#define MIME_RGBA	"x-rgba"
#define MIME_BW		"x-bw"
#define MIME_VRE	"x-vre"
#define MIME_MD2	"x-md2"
#define MIME_TXF	"x-txf"
#define MIME_PLAIN	"plain"

enum {
  TYPE_UNKNOWN=1,
  TYPE_PPM,
  TYPE_GIF,
  TYPE_JPG,
  TYPE_PNG,
  TYPE_PCX,
  TYPE_SGI,
  TYPE_CGI,
  TYPE_PLAIN
};

typedef struct _Image {
  u_int16 xsize;	/* image width in pixels */
  u_int16 ysize;	/* image height in pixels */
  u_int8 format;	/* bytes per pixel */
  u_int8 type;		/* type */
  u_int8 *pixmap;	/* image data */
} Image;

typedef struct _Anim_Image {
  Image image;
  struct _Anim_Image *next;
} Anim_Image;

typedef struct _Image_Anim {
  float delay;
  u_int16 nb_images;
  Anim_Image *images;
} Image_Anim;

typedef int (*ReadImageFunc) (void *handle, char *buf, int length);
typedef void (*DisplayImageFunc) (void *handle, Image *image);


Image * loadPPM(void *h, ReadImageFunc rf, DisplayImageFunc df);
Image * loadGIF(void *h, ReadImageFunc rf, DisplayImageFunc df);
Image * loadJPG(void *h, ReadImageFunc rf, DisplayImageFunc df);
Image * loadPNG(void *h, ReadImageFunc rf, DisplayImageFunc df);
Image * loadPCX(void *h, ReadImageFunc rf, DisplayImageFunc df);
Image * loadSGI(void *h, ReadImageFunc rf, DisplayImageFunc df);

Image * newImage(u_int16 xsize, u_int16 ysize, u_int8 format, u_int8 type);
Image * resizeImage(u_int16 xsize, u_int16 ysize, u_int8 format, u_int8 type, Image *src);
void freeImage(Image *image);
void freeAnim(Image_Anim *anim);

int getImageTypeByExt(char *);
int getImageTypeByMime(char *);


#endif /* IMAGES_H */
