#ifndef GUY_H
#define GUY_H

#define GUY_TYPE 38
#define GUY_NAME "Guy"
#define	GUY_INIT guyInitFuncList

#include <GL/glu.h>

#define GUY_CYCLE_SIZE 50	/* orig = 100 */
#define GUY_CYCLE_STEP (1.0/GUY_CYCLE_SIZE)
#define GUY_OVERSAMPLE 10
#define GUY_MAX_CPOINTS 34   /* 2 end point ones and 10 in the middle */
#define GUY_MAX_JOINTS 9
#define GUY_NUM_JOINTS 5

typedef struct ControlPts {
  int numpoints;
  float xcoords[GUY_MAX_CPOINTS];
  float angles[GUY_MAX_CPOINTS];
} tControlPts;

class Guy: public WObject {
public:
  float rotx;
  float roty;
  float rotz;
  float fstep;		// floating point for non-integer steping
  float incstep;
  u_int8 step;		// position in cycle, start in middle
  u_int8 numjoints;
  u_int8 anim;
  u_int8 walk;
  GLUquadricObj *quadc, *quads;
  int body_lists;
  float walk_cycle[2][GUY_MAX_JOINTS][GUY_CYCLE_SIZE]; // array of angles
  tControlPts *curve;	// series of ctrl points for a joint

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Guy(char *);	// constructor

  static void (creator)(char *);
  virtual void changePermanent(float lasting);
  virtual void render();
  virtual void quit();
};

void GUY_INIT(void);

#endif /* GUY_H */
