#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* projectMovementOnObject */
#include "user.h"	/* USER_TYPE */
#include "ball.h"	/* BALL_TYPE */
#include "dart.h"	/* DART_TYPE */
#include "bullet.h"	/* BULLET_TYPE */
#include "gate.h"

#include "zv.h"		/* parseGeometry */
#include "gui.h"	/* GuiUpdateWorld */
#include "channel.h"	/* joinChannel quitChannel */
#include "helpers.h"	/* playSound */


const WClass Gate::wclass(GATE_TYPE, "Gate", Gate::creator);


/* create a gate from a fileline */
void Gate::creator(char *l)
{
  new Gate(l);
}

Gate::Gate(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  if (isdigit((int) *l))
    strcpy(chan, l); l = strtok(NULL, SEP);
  soh = parseGeometry(l);

  l = strtok(NULL, SEP);
  if (l != NULL) {
    int autoenter = (int) atoi(l); l = strtok(NULL, SEP);
    this->autoEnter = (autoenter == 0 ? FALSE : TRUE);
  }
  else
    this->autoEnter = FALSE;

  initializeObject(this, GATE_TYPE, VR_STILL);
  nature.collision = COL_ONCE;
} 

static
void gateEnter(Gate *po, void *data, time_t sec, time_t usec)
{
  char *chanstr, new_url[URL_LEN], new_chan_str[CHAN_LEN];

  if (strcmp(po->name.url, universe.urlinitial) == 0) {
    sprintf(po->chan, "%s/%u/%d",
            universe.groupinitial, universe.portinitial, getCurrentTtl());
    trace(DBG_IPMC, "world initial = %s", po->chan);
  }
  /* save url and chan, because quitWorld frees po */
  strcpy(new_url, po->name.url);
  strcpy(new_chan_str, po->chan);

  quitWorld();
  quitChannel(getCurrentChannel());
  thisWorldIsDead = TRUE;
#if 0
  playSound(GATESND);
#endif

  newWorld(new_url, new_chan_str, VR_NEW);
  chanstr = strdup(joinChannel(new_chan_str));
  trace(DBG_WMGT, "gateEnter: join channel=%s url=%s", new_chan_str, new_url);

  GuiUpdateWorld(worlds, VR_CURR);

  //TODO declareJoinWorldToManager(new_url, chanstr, worlds->plocaluser->name.instance_name);

  if (audioactive)
    startaudio(chanstr);
  free(chanstr);
}

/* when an intersection occurs */
void Gate::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->noh.type) {
  case USER_TYPE:
    if (this->autoEnter == TRUE) {
      if (pcur != worlds->plocaluser) {
	notice("A user was just pushed out of this world");
        return;
      }
      else {
        pcur->state.collide = 0;
        gateEnter(this, NULL, 0L, 0L);
      }
    }
    else {
      if (pcur->state.collide < 10) {
        copyPositionAndBB(pold, pcur);
        notice("Warning! You are near the gate %s in=%d", name.instance_name, pcur->state.collide);
        pcur->state.collide++;
      }
      else if (pcur->state.collide < 20) {
        copyPositionAndBB(pold, pcur);
        notice("Warning! If you insist you'll enter in the gate %s in=%d", name.instance_name, pcur->state.collide);
        pcur->state.collide++;
      }
      else {
        gateEnter(this, NULL, 0L, 0L);
        pcur->state.collide = 0;
      }
    }
    break;
  case BULLET_TYPE:
  case DART_TYPE:
    notice("%s:%s hits %s:%s",
            pcur->name.class_name, pcur->name.instance_name,
            name.class_name, name.instance_name);
    copyPositionAndBB(pold, pcur);
    objectToDelete(pcur);
    break;
  case BALL_TYPE:
    if (projectMovementOnObject(pcur->pos, pold->pos, this->pos))
      updateReplica(pcur, pold->pos);
    else
      copyPositionAndBB(pold, pcur);
    break;
  default:	/* other objects */
    copyPositionAndBB(pold, pcur);
  }
}

void gateInitFuncList(void)
{
  setMethodFunc(GATE_TYPE, 0, WO_ACTION gateEnter, "Enter");
}

#endif /* !VRENGD */
