/*
 * Wget tool
 *
 * Philippe Dax
 * May 2000
 */

#ifndef VRENGD

#include "global.h"


static char tmppath[64];


char * startwget(const char *url)
{
  const char *tmpfile;

  memset(tmppath, 0, sizeof(tmppath));
  tmpfile = strrchr(url, '/');
  sprintf(tmppath, "/tmp/%s", ++tmpfile);

  switch (fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for wget");
    return(NULL);
  case 0:
    execlp("wget", "wget", "-qO", tmppath, url, (char *) NULL);
    trace(DBG_FORCE, "can't exec wget");
    exit(1);
  default:
    my_wait();
    return(tmppath);
  }
}

void unlinktmp(char *path)
{
  if (access(path, W_OK) == 0)
    unlink(path);
}


#endif /* !VRENGD */
