#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"

/***    object includes    ***/
#include "user.h"	/* 01 */
#include "wall.h"	/* 02 */
#include "door.h"	/* 03 */
#include "caul.h"	/* 04 */
#include "ball.h"	/* 05 */
#include "step.h"	/* 06 */
#include "earth.h"	/* 07 */
#include "gate.h"	/* 08 */
#include "host.h"	/* 09 */
#include "board.h"	/* 10 */
#include "web.h"	/* 11 */
#include "button.h"	/* 12 */
#include "anim.h"	/* 13 */
#include "lift.h"	/* 14 */
#include "bullet.h"	/* 15 */
#include "dart.h"	/* 16 */
#include "cell.h"	/* 17 */
#include "aoi.h"	/* 18 */
#include "doc.h"	/* 19 */
#include "walls.h"	/* 20 */
#include "entry.h"	/* 21 */
#include "bgcolor.h"	/* 22 */
#include "panel.h"	/* 23 */
#include "stars.h"	/* 24 */
#include "cd.h"	  	/* 25 */
#include "mirror.h"	/* 26 */
#include "clock.h"	/* 27 */
#include "clip.h"	/* 28 */
#include "moon.h"	/* 29 */
#include "ftp.h"	/* 30 */
#include "water.h"	/* 31 */
#include "mech.h"	/* 32 */
#include "plain.h"	/* 33 */
#include "light.h"	/* 34 */
#include "text.h"	/* 35 */
#include "cinema.h"	/* 36 */
#include "link.h"	/* 37 */
#include "guy.h"	/* 38 */
#include "thing.h"	/* 39 */
#include "android.h"	/* 40 */
#include "vnc.h"	/* 41 */
#include "ifc.h"	/* 42 */
#include "ifcserver.h"	/* 43 */


GeneralInitList generalInitList[] = {
/* 00 */	{END_NAME,	END_TYPE,	NULL},
/* 01 */	{USER_NAME,	USER_TYPE,	USER_INIT},
/* 02 */	{WALL_NAME,	WALL_TYPE,	WALL_INIT},
/* 03 */	{DOOR_NAME,	DOOR_TYPE,	DOOR_INIT},
/* 04 */	{CAULDRON_NAME,	CAULDRON_TYPE,	CAULDRON_INIT},
/* 05 */	{BALL_NAME,	BALL_TYPE,	BALL_INIT},
/* 06 */	{STEP_NAME,	STEP_TYPE,	STEP_INIT},
/* 07 */	{EARTH_NAME,	EARTH_TYPE,	EARTH_INIT},
/* 08 */	{GATE_NAME,	GATE_TYPE,	GATE_INIT},
/* 09 */	{HOST_NAME,	HOST_TYPE,	HOST_INIT},
/* 10 */	{BOARD_NAME,	BOARD_TYPE,	BOARD_INIT},
/* 11 */	{WEB_NAME,	WEB_TYPE,	WEB_INIT},
/* 12 */	{BUTTON_NAME,	BUTTON_TYPE,	BUTTON_INIT},
/* 13 */	{ANIM_NAME,	ANIM_TYPE,	ANIM_INIT},
/* 14 */	{LIFT_NAME,	LIFT_TYPE,	LIFT_INIT},
/* 15 */	{BULLET_NAME,	BULLET_TYPE,	BULLET_INIT},
/* 16 */	{DART_NAME,	DART_TYPE,	DART_INIT},
/* 17 */	{CELL_NAME,	CELL_TYPE,	CELL_INIT},
/* 18 */	{AOI_NAME,	AOI_TYPE,	AOI_INIT},
/* 19 */	{DOC_NAME,	DOC_TYPE,	DOC_INIT},
/* 20 */	{WALLS_NAME,	WALLS_TYPE,	WALLS_INIT},
/* 21 */	{ENTRY_NAME,	ENTRY_TYPE,	ENTRY_INIT},
/* 22 */	{BGCOLOR_NAME,	BGCOLOR_TYPE,	BGCOLOR_INIT},
/* 23 */	{PANEL_NAME,	PANEL_TYPE,	PANEL_INIT},
/* 24 */	{STARS_NAME,	STARS_TYPE,	STARS_INIT},
/* 25 */	{CD_NAME,	CD_TYPE,	CD_INIT},
/* 26 */	{MIRROR_NAME,	MIRROR_TYPE,	MIRROR_INIT},
/* 27 */	{CLOCK_NAME,	CLOCK_TYPE,	CLOCK_INIT},
/* 28 */	{CLIP_NAME,	CLIP_TYPE,	CLIP_INIT},
/* 29 */	{MOON_NAME,	MOON_TYPE,	MOON_INIT},
/* 30 */	{FTP_NAME,	FTP_TYPE,	FTP_INIT},
/* 31 */	{WATER_NAME,	WATER_TYPE,	WATER_INIT},
/* 32 */	{MECH_NAME,	MECH_TYPE,	MECH_INIT},
/* 33 */	{PLAIN_NAME,	PLAIN_TYPE,	PLAIN_INIT},
/* 34 */	{LIGHT_NAME,	LIGHT_TYPE,	LIGHT_INIT},
/* 35 */	{TEXT_NAME,	TEXT_TYPE,	TEXT_INIT},
/* 36 */	{CINEMA_NAME,	CINEMA_TYPE,	CINEMA_INIT},
/* 37 */	{LINK_NAME,	LINK_TYPE,	LINK_INIT},
/* 38 */	{GUY_NAME,	GUY_TYPE,	GUY_INIT},
/* 39 */	{THING_NAME,	THING_TYPE,	THING_INIT},
/* 40 */	{ANDROID_NAME,	ANDROID_TYPE,	ANDROID_INIT},
/* 41 */	{VNC_NAME,	VNC_TYPE,	VNC_INIT},
/* 42 */	{IFC_NAME,	IFC_TYPE,	IFC_INIT},
/* 43 */	{IFCSERVER_NAME,IFCSERVER_TYPE,	IFCSERVER_INIT},
/* END */	{"",		UNKNOWN_TYPE,	NULL}
};


/* initialization array of functions pointers */
void initGeneralFuncList(void)
{
  for (int i = 0; i < OBJECTSNUMBER; i++) {

    // action functions
    for (int j = 0; j < METHODSNUMBER; j++) {
      generalMethodList[j][i].type_name[0] = '\0';
      generalMethodList[j][i].method = NULL;
    }

    // property functions
    for (int j = 0; j < PROPSNUMBER; j++) {
      setFuncList[j][i].pf = NULL;
      getFuncList[j][i].pf = NULL;
    }    

    // property & maxlasting values
    propertiesnumber[i] = 0;
    maxlasting[i] = MAXFLOAT;

    // init functions
    if (generalInitList[i].initfunc != NULL) {
      trace(DBG_WMGT, "initfunc: i=%d f=%x", i, generalInitList[i].initfunc);
      generalInitList[i].initfunc();
    }
  }
}
