#ifndef BALL_H
#define BALL_H

#define BALL_TYPE	5
#define BALL_NAME	"Ball"
#define BALL_INIT	ballInitFuncList
#define BALL_LASTING	0.03	/* 30 ms */
#define BALL_PROPS	5

#define BALL_PROPHNAME	0
#define BALL_PROPXY	1
#define BALL_PROPZ	2
#define BALL_PROPAZ	3
#define BALL_PROPAY	4

#define BALL_RADIUS	0.1	// 10 cm
#define BALL_LSPEED	7.0	// 7 m/s
#define BALL_ZSPEED	3.0	// 3 m/s
#define BALL_ASPEED	-0.5	// 0.5 rd/s
#define BALL_FLYTTL	5.0	// 5 s
#define BALL_REMAINT	0.0005	// 0.0005 s
#define BALL_DELTAZ	0.02	// 2 cm
#define BALL_SHIFTX	1.0	// 1 m
#define BALL_SHIFTY	1.0	// 1 m
#define BALL_ORIGZ	1.0	// 1 m
#define BALL_COLOR	"1,1,0"	// yellow
#define BALL_DENSITY	0.1

/* actions */
#define BALL_PUSH	0
#define BALL_PULL	1
#define BALL_SHOOT	2
#define BALL_KILL	3
#define BALL_CREAT	4
#define BALL_UP		5


class Ball: public WObject {
public:
  float lspeed;		// linear speed
  float ttl;		// time to live
  float origz;

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Ball(WObject *, void *, time_t, time_t);
  Ball(u_int8 type_id, struct _NetObjectId noid, struct _Payload *);

  static WObject * replicator(u_int8 type_id, struct _NetObjectId, struct _Payload *pp);

  virtual boolean change();
  virtual void changePosition(float lasting);
  virtual void changePermanent(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual boolean updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
};

void BALL_INIT(void);

#endif /* BALL_H */
