#ifndef THREAD_H
#define THREAD_H


#define THREAD_NO_BLOCK    1
#define THREAD_NO_NONBLOCK 0

#if defined(HAVE_LIBPTHREAD)
typedef pthread_t Vpthread_t;
typedef pthread_cond_t Vpthread_cond_t;
typedef pthread_mutex_t Vpthread_mutex_t;
#else
typedef int Vpthread_t;
typedef int Vpthread_cond_t;
typedef int Vpthread_mutex_t;
#endif /* WITH_PTHREAD */

/* FIFO if max connections is reached */
typedef struct _waitfifo {
  Vpthread_cond_t cond;
  struct _waitfifo *next;
} WaitFIFO;

/* structure to launch a thread */
typedef struct _threadlaunch {
  void *handle;
  char url[URL_LEN];
  //DAX int (*callback) (void *, void *);
  void (*callback) (void *, void *);
  WaitFIFO *wait;
  int block;
} ThreadLaunch;

/* global variables */
extern int maxsimcon, nbsimcon;
extern Vpthread_mutex_t nbsimcon_mutex;
extern WaitFIFO *fifofirst, *fifolast; /* protected by nbsimcon_mutex */


void initThreads(void);
void initMutex(Vpthread_mutex_t *);
void lockMutex(Vpthread_mutex_t *);
void unlockMutex(Vpthread_mutex_t *);
void beginThread(ThreadLaunch *);
void endThread(ThreadLaunch *);
int fifoThread(ThreadLaunch *);


#endif /* THREAD_H */
