//=======================================================================
// V/VIDE helper class - vPipedProcess
//  Copyright (C) 2000  Bruce E. Wampler
//
//  This program is part of the VIDE and the V C++ GUI Framework
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=======================================================================

#ifndef vPipedProcess_h
#define vPipedProcess_h

#ifndef PP_NON_V
#include <v/v_defs.h>
#else
    // for Non-V versions, define one or the other of these
#define V_VersionWindows
//#define V_VersionX
#endif

#ifdef V_VersionX
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
    const int pREAD = 0;
    const int pWRITE = 1;
#endif

    class vPipedProcess
      {
      public:
	vPipedProcess();
	~vPipedProcess();

	bool startPipedProcess(char* cmd);
	bool stillRunning();
	void killProcess(int exitCode = 99);
	int readChar(char* chrin);
	void writeChars(char* line);

        long getExitCode() { return (long)_exitCode; }
        long getErrorCode() { return (long)_errorCode; }

      protected:

      private:

	bool _running;

#ifdef V_VersionWindows
	HANDLE _processThread;
	HANDLE _processHandle;
	DWORD _processId;
	DWORD _errorCode;
	DWORD _exitCode;

	HANDLE hChildStdinRd, hChildStdinWr, hChildStdinWrDup, 
	  hChildStdoutRd, hChildStdoutWr, 
	  hChildStderrRd, hChildStderrWr, 
	  hSaveStdin, hSaveStdout, hSaveStderr; 
#endif
#ifdef V_VersionX
	long _exitCode;
	long _errorCode;

	int to_child[2];	// pipes
	int to_parent[2];
	int to_parent_error[2];

	FILE *_inputfp;	    	// read from child
	FILE *_outputfp;	// write to child
	FILE *_errorfp;	    	// read errors from child

	pid_t _pid;		// child's process id
#endif
      };
#endif

