#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <vslib.h>

#include "ftplib.h"

#define VER     "2.5"

#define MAXLINE 2048
#define MAXMSGLEN 77

int ftpopen = 0;
int quiet   = 0;
int recurse = 0;
char   cmd  = 0; // command
String host; // host name
String user; // user name
String pass; // password
String tmpf; // temp file
String arcf; // archive file
String rpath;
PSZCluster list;
PSZCluster files;

/*-----------------------------------------------------------------------*/
/* read string from console */

int gets( String &str )
{
  str = "";
  int ch = getchar();
  while( ch != 27 && ch != 13 && ch != 10 )
    {
    str_add_ch( str, ch );
    ch = getchar();
    };
  if ( ch == 27 ) str = "";
};

/*-----------------------------------------------------------------------*/

void say( const char* msg )
{
  if (quiet) return;
  fprintf( stderr, "%s\n", msg );
  fflush( stderr );
};

/*-----------------------------------------------------------------------*/

int fa_open()
{
  PSZCluster tmplist;
  String msg;
  tmplist.create( 3, 3 );
  if( LoadFromFile( arcf, &tmplist, MAXLINE ) || tmplist.count() < 3 )
    {
    msg = arcf;
    msg = "error: cannot read file: " + msg + ", or it contains wrong data";
    say( msg );
    return 1;
    }
  host = tmplist[0];
  user = tmplist[1];
  pass = tmplist[2];
  if (user == "?")
    {
    say( " username? ( enter to confirm, esc+enter to cancel )");
    gets( user );
    }
  if (user == "-" || user == "") user = "anonymous";
  if (pass == "?")
    {
    say( " password? ( enter to confirm, esc+enter to cancel )");
    gets( pass );
    }
  if (pass == "-" || pass == "")
    {
    pass = "";
    if (getenv("USER"))
      pass += getenv("HOME");
    else
      pass += "anonymous";
    pass += "@";
    if (getenv("HOSTNAME"))
      pass += getenv("HOSTNAME");
    else
      pass += "unknown.org";
    msg = pass;
    };
  if (msg == "") msg = "(password)";
  msg = arcf + "@ftp://" + user + ":password" + "@" + host + rpath + " ";
  say( msg );

  if(ftpOpen( host ) == 0)
    {
    msg = "error: open failed: ";
    msg += ftplib_lastresp;
    return 2;
    }
  ftpopen = 1;
  if(ftpLogin( user, pass ) == 0)
    {
    msg = "error: login failed: ";
    msg += ftplib_lastresp;
    return 3;
    }
  return 0;
};

/*-----------------------------------------------------------------------*/

int fa_rlist( const char* path ) // recursive dir
{
  int z;
  int i;
  PSZCluster tmplist;
  String str;
  String name;
  tmplist.create( 16, 16 );
  ftpDir( tmpf, path );
  LoadFromFile( tmpf, &tmplist, MAXLINE );
  for( z = 0; z < tmplist.count(); z++ )
    {
    str = tmplist[z];
    str_cut( str, "\n\r" );
    if ( str_find( str, "total " ) == 0 ) continue; // hack
    if ( (i = str_rfind( str, ' ' )) == -1 ) continue; // consider it error

    name = str;
    str_trim_left( name, i+1 );
    if ( name == "." || name == ".." ) continue; // skip those

    if (recurse)
      str_ins( str, i+1, path );
    if ( str[0] == 'd' )
      str += "/";
    list.add( str );
    if ( recurse && str[0] == 'd' )
      { // directory
        str = path;
        str += name;
        str += "/";
        fa_rlist( str );
      }
    };
  if (recurse && !quiet)
    {
    sprintf( str, "entries: %5d (%s)", list.count(), path );
    say( str );
    }
};

/*-----------------------------------------------------------------------*/

int fa_list( const char* path )
{
  fa_rlist( path );
  say( "list done" );
  unlink( tmpf );
  int z;
  for ( z = 0; z < list.count(); z++ )
    printf( "%s\n", (const char*)(list[z]) );
};

/*-----------------------------------------------------------------------*/

int fa_extract( int fullpath )
{
  char path[MAX_PATH];
  int z;
  for ( z = 0; z < files.count(); z++ )
    {
    String str = files[z];
    String str2;
    str = rpath + str;
    str_cut_left( str, " /" ); /* strips spaces and leading `/' */
    path[0] = 0;
    str_file_path( str, path );
    make_path( path );
    str2 = str;
    if ( fullpath == 0 )
      str_trim_left( str2, str_rfind( str2, '/' ) + 1 );
    if ( fullpath == 2 )
      ftpGet( NULL, str, 'I' ); // pipe to stdout
    else
      ftpGet( str2, str, 'I' );
    };
  return 0;
};

/*-----------------------------------------------------------------------*/

int fa_add()
{
  fprintf( stderr, "ftparc: not implemented yet... sorry\n" );
  return 0;
};

/*************************************************************************/

extern char ftplib_version[];

void usage()
{
  printf( "ftparc " VER " (c) Vladi Belperchinov-Shabanski <cade@biscom.net> 1999-2000\n" );
  printf( "using %s\n", ftplib_version );
  printf(
  "ftparc is archive-like interface to FTP sites\n"
  "usage: ftparc command switches ftp_arc_file remote-path/ filenames @listfile\n"
  "command:\n"
  "   -l   -- list files in archive (ftp site)\n"
  "   -x   -- extract (download) file(s) with full path\n"
  "   -e   -- extract (download) file(s) without path\n"
  "   -p   -- extract (download) and print file to console\n"
  "   -a   -- add (upload) file(s)\n"
  "   -h   -- help (this screen)\n"
  "switches:\n"
  "   -q   -- quiet mode (no progress messages)\n"
  "   -r   -- recursive (list only)\n"
  "notes:\n"
  "   `remote-path' should end with `/'! otherwise it is accepted as file mask!\n"
  "ftp_arc_file syntax:\n"
  "   it is recommended this file to have `.ftp' extension, content has to be:\n"
  "   line 1 -- host name\n"
  "   line 2 -- user name ( use `-' for `anonymous' or `?' to ask )\n"
  "   line 3 -- password ( use `-' for `loginid@localhost' or use `?' to ask )\n"
  "Compile date: " __DATE__ "\n"
  );
  if (ftpopen) ftpQuit();
  exit(200);
};

/*************************************************************************/

void fa_sig( int sig )
{
  if (ftpopen) ftpQuit();
  exit(100);
};


/*************************************************************************/

int main( int argc, char* argv[] )
{
  if ( argc < 3 )
    usage();

  ftpInit();
  signal( SIGINT , fa_sig );
  signal( SIGHUP , fa_sig );
  signal( SIGTERM, fa_sig );
  signal( SIGQUIT, fa_sig );

  list.create( 16, 16 );
  files.create( 16, 16 );
  tmpf = tmpnam( NULL );
  if (tmpf == "") tmpf = ".ftparc.tmp";

  GETOPT( "lxepahqr" )
    {
    switch(optc)
      {
      case 'l' : cmd = optc; break;
      case 'e' : cmd = optc; break;
      case 'x' : cmd = optc; break;
      case 'a' : cmd = optc; break;
      case 'p' : cmd = optc; break;
      case 'r' : recurse = 1; break;
      case 'q' : quiet = 1; break;
      case '+' :
                 if (arcf == "")
                   arcf = optarg;
                 else
                 if (optarg[0] == '@')
                   LoadFromFile( optarg+1, &files, MAXLINE );
                 else
                   if ( str_get_ch( optarg, -1 ) == '/' )
                     rpath = optarg;
                   else
                     files.add( optarg );
                 break;
      case 'h' :
      default  :
                 usage(); break;
      }
    };

  if ( arcf != "" )
    {
    arcf += ".ftp";
    str_replace( arcf, ".ftp.ftp", ".ftp" );
    };
  if ( rpath == "" )
    rpath = "/";

  if(fa_open() == 0)
    switch(cmd)
      {
      case 'l' : fa_list( rpath ); break;
      case 'e' : fa_extract( 0 ); break;
      case 'x' : fa_extract( 1 ); break;
      case 'p' : fa_extract( 2 ); break;
      case 'a' : fa_add(); break;
      default  : usage(); break;
      }
  say( "end" );
  if (ftpopen) ftpQuit();
  return 0;
};



