.TH vvp 1 "$Date: 2001/07/29 22:50:44 $" Version "$Date: 2001/07/29 22:50:44 $"
.SH NAME
vvp - Icarus Verilog vvp runtime engine

.SH SYNOPSIS
.B vvp
[-dv] [-Mpath] [-mmodule] [-llogfile] inputfile

.SH DESCRIPTION
.PP
\fIvvp\fP is the run time engine that executes the default compiled
form generated by Icarus Verilog. The output from the \fIiverilog\fP
command is not by itself executable on any platform. Instead, the
\fIvvp\fP program is invoked to execute the generated output file.

.SH OPTIONS
.l
\fIvvp\fP accepts the following options:
.TP 8
.B -l\fIlogfile\fP
This flag specifies a logfile where all MCI <stdlog> output goes.
Specify logfile as '-' to send log output to <stderr>.  $display and
friends send their output both to <stdout> and <stdlog>.
.TP 8
.B -M\fIpath\fP
This flag adds a directory to the path list used to locate VPI
modules. The default path includes only the install directory for the
system.vpi module, but this flag can add other directories. Multiple
paths are allowed, and modules will be searched in order.
.TP 8
.B -m\fImodule\fP
Tell the vvp run time to load the named module before executing the
simulation. The \fBsystem.vpi\fP module is loaded by default, but
additional modules, including modules that you compiled locally, can
be specified with this flag. Any number of modules can be loaded, and
they will be linked in the order they are listed on the command line.

Normally, you only need to specify the name of the module, without any
directory path or .vpi suffix and the search path is scanned to find
the module. However, if the name includes at least one directory
character, then the search path is not scanned and the name is assumed
to be a complete file name.
.TP 8
.B -v
Turn on verbose messages. This will cause information about run time
progress to be printed to standard out.

.SH "AUTHOR"
.nf
Steve Williams (steve@icarus.com)

.SH SEE ALSO
iverilog(1),
.BR "<http://www.icarus.com/eda/verilog/>"

.SH COPYRIGHT
.nf
Copyright \(co  2001 Stephen Williams

This document can be freely redistributed according to the terms of the 
GNU General Public License version 2.0
