/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.KeepValue;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontState;

public class TableRow
extends FObj {
    boolean setup = false;
    FontState fs;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    String id;
    ColorType borderTopColor;
    int borderTopWidth;
    int borderTopStyle;
    ColorType borderBottomColor;
    int borderBottomWidth;
    int borderBottomStyle;
    ColorType borderLeftColor;
    int borderLeftWidth;
    int borderLeftStyle;
    ColorType borderRightColor;
    int borderRightWidth;
    int borderRightStyle;
    int paddingTop;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    KeepValue keepWithNext;
    KeepValue keepWithPrevious;
    int widthOfCellsSoFar = 0;
    int largestCellHeight = 0;
    Vector columns;
    AreaContainer areaContainer;
    DisplaySpace spacer = null;
    boolean hasAddedSpacer = false;
    DisplaySpace spacerAfter = null;
    boolean areaAdded = false;
    public Vector cells = null;

    public TableRow(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-row";
    }

    public void doSetup(Area area) throws FOPException {
        String string = this.properties.get("font-family").getString();
        String string2 = this.properties.get("font-style").getString();
        String string3 = this.properties.get("font-weight").getString();
        int n = this.properties.get("font-size").getLength().mvalue();
        int n2 = this.properties.get("font-variant").getEnum();
        this.fs = new FontState(area.getFontInfo(), string, string2, string3, n, n2);
        this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
        this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.borderBottomColor = this.borderTopColor = this.properties.get("border-color").getColorType();
        this.borderLeftColor = this.borderTopColor;
        this.borderRightColor = this.borderTopColor;
        if (this.borderTopColor == null) {
            this.borderTopColor = this.properties.get("border-top-color").getColorType();
            this.borderBottomColor = this.properties.get("border-bottom-color").getColorType();
            this.borderLeftColor = this.properties.get("border-left-color").getColorType();
            this.borderRightColor = this.properties.get("border-right-color").getColorType();
        }
        this.borderBottomWidth = this.borderTopWidth = this.properties.get("border-width").getLength().mvalue();
        this.borderLeftWidth = this.borderTopWidth;
        this.borderRightWidth = this.borderTopWidth;
        if (this.borderTopWidth == 0) {
            this.borderTopWidth = this.properties.get("border-top-width").getLength().mvalue();
            this.borderBottomWidth = this.properties.get("border-bottom-width").getLength().mvalue();
            this.borderLeftWidth = this.properties.get("border-left-width").getLength().mvalue();
            this.borderRightWidth = this.properties.get("border-right-width").getLength().mvalue();
        }
        this.borderBottomStyle = this.borderTopStyle = this.properties.get("border-style").getEnum();
        this.borderLeftStyle = this.borderTopStyle;
        this.borderRightStyle = this.borderTopStyle;
        if (this.borderTopStyle == 0) {
            this.borderTopStyle = this.properties.get("border-top-style").getEnum();
            this.borderBottomStyle = this.properties.get("border-bottom-style").getEnum();
            this.borderLeftStyle = this.properties.get("border-left-style").getEnum();
            this.borderRightStyle = this.properties.get("border-right-style").getEnum();
        }
        this.keepWithNext = this.getKeepValue("keep-with-next.within-column");
        this.keepWithPrevious = this.getKeepValue("keep-with-previous.within-column");
        this.paddingLeft = this.paddingTop = this.properties.get("padding").getLength().mvalue();
        this.paddingRight = this.paddingTop;
        this.paddingBottom = this.paddingTop;
        if (this.paddingTop == 0) {
            this.paddingTop = this.properties.get("padding-top").getLength().mvalue();
            this.paddingLeft = this.properties.get("padding-left").getLength().mvalue();
            this.paddingBottom = this.properties.get("padding-bottom").getLength().mvalue();
            this.paddingRight = this.properties.get("padding-right").getLength().mvalue();
        }
        this.id = this.properties.get("id").getString();
        this.setup = true;
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    private KeepValue getKeepValue(String string) {
        Property property = this.properties.get(string);
        Number number = property.getNumber();
        if (number != null) {
            return new KeepValue("KEEP_WITH_VALUE", number.intValue());
        }
        switch (property.getEnum()) {
            case 2: {
                return new KeepValue("KEEP_WITH_ALWAYS", 0);
            }
        }
        return new KeepValue("KEEP_WITH_AUTO", 0);
    }

    public KeepValue getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    /*
     * Unable to fully structure code
     */
    public Status layout(Area var1_1) throws FOPException {
        var2_2 = false;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            if (!this.setup) {
                this.doSetup(var1_1);
            }
            if (var1_1 instanceof BlockArea) {
                var1_1.end();
            }
            if (this.cells == null) {
                var1_1.getIDReferences().createID(this.id);
                var2_2 = true;
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            this.spacer = new DisplaySpace(this.spaceBefore);
            var1_1.increaseHeight(this.spaceBefore);
        }
        if (this.marker == 0 && var2_2) {
            var1_1.getIDReferences().configureID(this.id, var1_1);
        }
        this.areaContainer = new AreaContainer(this.fs, -var1_1.borderWidthLeft, -var1_1.borderWidthTop, var1_1.getAllocationWidth(), var1_1.spaceLeft(), 2);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(var1_1.getPage());
        this.areaContainer.setPadding(this.paddingTop, this.paddingLeft, this.paddingBottom, this.paddingRight);
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderTopStyle, this.borderLeftStyle, this.borderBottomStyle, this.borderRightStyle);
        this.areaContainer.setBorderWidth(this.borderTopWidth, this.borderLeftWidth, this.borderBottomWidth, this.borderRightWidth);
        this.areaContainer.setBorderColor(this.borderTopColor, this.borderLeftColor, this.borderBottomColor, this.borderRightColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(var1_1.getAbsoluteHeight());
        this.areaContainer.setIDReferences(var1_1.getIDReferences());
        if (this.cells == null) {
            this.widthOfCellsSoFar = 0;
            this.cells = new Vector<E>();
            var3_3 = 0;
            var4_4 = this.children.size();
            var5_5 = 0;
            while (var5_5 < var4_4) {
                var6_6 = (TableCell)this.children.elementAt(var5_5);
                var6_6.doSetup(this.areaContainer);
                var7_8 = var6_6.getNumColumnsSpanned();
                var8_11 = var6_6.getNumRowsSpanned();
                var9_14 = 0;
                var10_15 = new CellState(var5_5, false, this.widthOfCellsSoFar);
                var10_15.setColumn(var3_3);
                this.cells.insertElementAt(var10_15, var5_5);
                var11_16 = 0;
                while (var11_16 < var7_8 && var11_16 < this.columns.size()) {
                    var9_14 += ((TableColumn)this.columns.elementAt(var3_3)).getColumnWidth();
                    ++var3_3;
                    ++var11_16;
                }
                var6_6.setWidth(var9_14);
                this.widthOfCellsSoFar += var9_14;
                ++var5_5;
            }
        }
        var3_3 = this.children.size();
        this.largestCellHeight = 0;
        var4_4 = 0;
        var5_5 = this.marker;
        while (var5_5 < var3_3) {
            var6_6 = (TableCell)this.children.elementAt(var5_5);
            var7_9 = (CellState)this.cells.elementAt(var5_5);
            var6_6.setStartOffset(var7_9.getWidthOfCellSoFar());
            var8_12 = var6_6.layout(this.areaContainer);
            if (!var8_12.isIncomplete()) ** GOTO lbl89
            this.marker = var5_5;
            if (var8_12.getCode() == 3) {
                var7_9.setLayoutComplete(false);
                var9_14 = 0;
                while (var9_14 < var3_3) {
                    var10_15 = (CellState)this.cells.elementAt(var9_14);
                    if (!var10_15.isLayoutComplete()) {
                        this.marker = var9_14;
                        break;
                    }
                    ++var9_14;
                }
            } else {
                if (this.spacer != null) {
                    var1_1.removeChild(this.spacer);
                    this.spacer = null;
                }
                this.hasAddedSpacer = false;
                if (this.spacerAfter != null) {
                    var1_1.removeChild(this.spacerAfter);
                }
                this.spacerAfter = null;
                var1_1.increaseHeight(this.areaContainer.getHeight());
                var1_1.removeChild(this.areaContainer);
                this.resetMarker();
                this.removeID(var1_1.getIDReferences());
                var7_9.setLayoutComplete(false);
                return var8_12;
lbl89:
                // 1 sources

                var7_9.setLayoutComplete(true);
            }
            var9_14 = var6_6.getHeight();
            if (var9_14 > this.largestCellHeight) {
                this.largestCellHeight = var9_14;
            }
            ++var5_5;
        }
        var6_7 = 0;
        while (var6_7 < var3_3) {
            var7_10 = (TableCell)this.children.elementAt(var6_7);
            var7_10.setRowHeight(this.largestCellHeight);
            ++var6_7;
        }
        if (!this.hasAddedSpacer && this.spacer != null) {
            var1_1.addChild(this.spacer);
            this.hasAddedSpacer = true;
        }
        var1_1.addChild(this.areaContainer);
        this.areaContainer.setHeight(this.largestCellHeight);
        this.areaAdded = true;
        this.areaContainer.end();
        var1_1.addDisplaySpace(this.largestCellHeight + this.areaContainer.getPaddingTop() + this.areaContainer.borderWidthTop + this.areaContainer.getPaddingBottom() + this.areaContainer.borderWidthBottom);
        var7_8 = 0;
        while (var7_8 < var3_3) {
            var8_13 = (CellState)this.cells.elementAt(var7_8);
            if (!var8_13.isLayoutComplete()) {
                var4_4 = 1;
                break;
            }
            ++var7_8;
        }
        if (var4_4 == 0 && this.spaceAfter != 0) {
            this.spacerAfter = new DisplaySpace(this.spaceAfter);
            var1_1.addChild(this.spacerAfter);
            var1_1.increaseHeight(this.spaceAfter);
        }
        if (var1_1 instanceof BlockArea) {
            var1_1.start();
        }
        if (var4_4 != 0) {
            return new Status(3);
        }
        if (this.keepWithNext.getType() != "KEEP_WITH_AUTO") {
            return new Status(8);
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void removeLayout(Area area) {
        if (this.spacer != null) {
            if (this.hasAddedSpacer) {
                area.removeChild(this.spacer);
            } else {
                area.increaseHeight(-this.spaceBefore);
            }
        }
        if (this.spacerAfter != null) {
            area.removeChild(this.spacerAfter);
        }
        if (this.areaAdded) {
            area.removeChild(this.areaContainer);
        }
        this.areaAdded = false;
        this.resetMarker();
        this.cells = null;
        this.removeID(area.getIDReferences());
    }

    public void resetMarker() {
        super.resetMarker();
        this.spacer = null;
        this.spacerAfter = null;
        this.hasAddedSpacer = false;
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableRow(fObj, propertyList);
        }
    }

    public final class CellState {
        private int location;
        private boolean layoutCompleted;
        private int widthOfCellSoFar;
        private int column = 0;

        public CellState() {
            this(0, false, 0);
        }

        public CellState(int n, boolean bl, int n2) {
            this.location = n;
            this.layoutCompleted = bl;
            this.widthOfCellSoFar = n2;
        }

        public int getColumn() {
            return this.column;
        }

        public final int getLocation() {
            return this.location;
        }

        public final int getWidthOfCellSoFar() {
            return this.widthOfCellSoFar;
        }

        public final boolean isLayoutComplete() {
            return this.layoutCompleted;
        }

        public void setColumn(int n) {
            this.column = n;
        }

        public final void setLayoutComplete(boolean bl) {
            this.layoutCompleted = bl;
        }

        public final void setLocation(int n) {
            this.location = n;
        }

        public final void setWidthOfCellSoFar(int n) {
            this.widthOfCellSoFar = n;
        }
    }
}

