
#include <testxdb.h>
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(TestxdbForm,VDKForm);
DEFINE_EVENT_LIST(TestxdbForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(TestxdbForm,VDKForm)
ON_SIGNAL(fieldList,realize_signal,OnfieldListRealize),
ON_SIGNAL(quitButton,clicked_signal,OnquitButtonClick),
ON_SIGNAL(memo,realize_signal,OnmemoRealize),
ON_SIGNAL(nextButton,clicked_signal,OnnextButtonClick),
ON_SIGNAL(prevButton,clicked_signal,OnnextButtonClick),
ON_SIGNAL(lastButton,clicked_signal,OnlastButtonClick),
ON_SIGNAL(firstButton,clicked_signal,OnlastButtonClick),
ON_SIGNAL(showdelButton,clicked_signal,OnshowdelButtonClick),
ON_SIGNAL(updateButton,clicked_signal,OnupdateButtonClick),
ON_SIGNAL(undelButton,clicked_signal,OnundelButtonClick),
ON_SIGNAL(delButton,clicked_signal,OndelButtonClick),
ON_SIGNAL(addButton,clicked_signal,OnaddButtonClick),
ON_SIGNAL(orderButton,clicked_signal,OnorderButtonClick),
ON_SIGNAL(fieldList,select_row_signal,OnfieldListSelectRow)
END_SIGNAL_MAP
/*
main form setup
*/
void
TestxdbForm::GUISetup(void)
{
	SetSize(559,301);
	Title = "testxdb Main Form";
statusbar = new VDKStatusbar(this);
statusbar->SetSize(459,25);
Add(statusbar,2,0,0,0);
notebook = new VDKNotebook(this);
Add(notebook,0,1,1,0);
notebook0_page0 = new VDKBox(this,v_box);
notebook->AddPage(notebook0_page0,"VDKXDBControls");
frame1 = new VDKFrame(this,"Fiels",v_box,shadow_etched_in);
frame1->Shadow = shadow_in;
frame1->Align = l_justify;
notebook0_page0->Add(frame1,0,1,1,0);
VBox15 = new VDKBox(this,v_box);
VBox15->SetSize(451,181);
frame1->Add(VBox15,l_justify,1,1,0);
VBox15->BorderWidth(0);
hbox17 = new VDKBox(this,h_box);
VBox15->Add(hbox17,0,1,1,0);
hbox17->BorderWidth(0);
table2 = new VDKTable(this,5,2,false);
table2->RowSpacing = 2;
table2->ColSpacing = 2;
hbox17->Add(table2,0,1,1,0);
vbox30 = new VDKBox(this,v_box);
table2->AddToCell(vbox30,0,0);
label4 = new VDKLabel(this,"First name:");
vbox30->Add(label4,0,1,1,0);
vbox31 = new VDKBox(this,v_box);
table2->AddToCell(vbox31,0,1);
firstname = new VDKXEntry(this,15);
firstname->Editable = true;
vbox31->Add(firstname,0,1,1,0);
#ifdef VDKXDB_SUPPORT
{
VDKString dbname;
TestxdbApp* app = dynamic_cast<TestxdbApp*>(Application());
dbname = XDB_DATA_PATH;
dbname += "myfamily.dbf";
if(app && app->TheXdb())
firstname->AssignTableField(app->TheXdb(),(char*) dbname,"FIRSTNAME");
}
#endif
vbox32 = new VDKBox(this,v_box);
table2->AddToCell(vbox32,1,0);
label5 = new VDKLabel(this,"Last name:");
vbox32->Add(label5,0,1,1,0);
vbox33 = new VDKBox(this,v_box);
table2->AddToCell(vbox33,1,1);
lastname = new VDKXEntry(this,15);
lastname->Editable = true;
vbox33->Add(lastname,0,1,1,0);
#ifdef VDKXDB_SUPPORT
{
VDKString dbname;
TestxdbApp* app = dynamic_cast<TestxdbApp*>(Application());
dbname = XDB_DATA_PATH;
dbname += "myfamily.dbf";
if(app && app->TheXdb())
lastname->AssignTableField(app->TheXdb(),(char*) dbname,"LASTNAME");
}
#endif
vbox34 = new VDKBox(this,v_box);
table2->AddToCell(vbox34,2,0);
label6 = new VDKLabel(this,"Birth date:");
vbox34->Add(label6,0,1,1,0);
vbox35 = new VDKBox(this,v_box);
table2->AddToCell(vbox35,2,1);
birthdate = new VDKXEntry(this,10);
birthdate->Editable = true;
vbox35->Add(birthdate,0,1,1,0);
#ifdef VDKXDB_SUPPORT
{
VDKString dbname;
TestxdbApp* app = dynamic_cast<TestxdbApp*>(Application());
dbname = XDB_DATA_PATH;
dbname += "myfamily.dbf";
if(app && app->TheXdb())
birthdate->AssignTableField(app->TheXdb(),(char*) dbname,"BIRTHDATE");
}
#endif
vbox36 = new VDKBox(this,v_box);
table2->AddToCell(vbox36,3,0);
label7 = new VDKLabel(this,"Sex:");
vbox36->Add(label7,0,1,1,0);
vbox37 = new VDKBox(this,v_box);
table2->AddToCell(vbox37,3,1);
sex = new VDKXEntry(this,1);
sex->SetSize(160,21);
sex->Editable = true;
vbox37->Add(sex,0,1,1,0);
#ifdef VDKXDB_SUPPORT
{
VDKString dbname;
TestxdbApp* app = dynamic_cast<TestxdbApp*>(Application());
dbname = XDB_DATA_PATH;
dbname += "myfamily.dbf";
if(app && app->TheXdb())
sex->AssignTableField(app->TheXdb(),(char*) dbname,"SEX");
}
#endif
vbox38 = new VDKBox(this,v_box);
table2->AddToCell(vbox38,4,0);
vbox39 = new VDKBox(this,v_box);
table2->AddToCell(vbox39,4,1);
ofage = new VDKXCheckButton(this,"Of age");
vbox39->Add(ofage,0,1,1,0);
#ifdef VDKXDB_SUPPORT
{
VDKString dbname;
TestxdbApp* app = dynamic_cast<TestxdbApp*>(Application());
dbname = XDB_DATA_PATH;
dbname += "myfamily.dbf";
if(app && app->TheXdb())
ofage->AssignTableField(app->TheXdb(),(char*) dbname,"OFAGE");
}
#endif
memo = new VDKXMemo(this,true);
memo->SetSize(228,183);
memo->WordWrap = false;
#ifdef VDKXDB_SUPPORT
{
VDKString dbname;
TestxdbApp* app = dynamic_cast<TestxdbApp*>(Application());
dbname = XDB_DATA_PATH;
dbname += "myfamily.dbf";
if(app && app->TheXdb())
memo->AssignTableField(app->TheXdb(),(char*) dbname,"MEMO");
}
#endif
hbox17->Add(memo,0,1,1,0);
hbox16 = new VDKBox(this,h_box);
hbox16->SetSize(455,26);
notebook0_page0->Add(hbox16,0,0,0,0);
hbox16->BorderWidth(0);
nextButton = new VDKCustomButton(this,(char*) NULL,"Next",16,(GtkPositionType) 1);
nextButton->SetTip("Goes to next record");
hbox16->Add(nextButton,0,1,1,0);
prevButton = new VDKCustomButton(this,(char*) NULL,"Prev",16,(GtkPositionType) 1);
prevButton->SetTip("Goes to previous record");
hbox16->Add(prevButton,0,1,1,0);
lastButton = new VDKCustomButton(this,(char*) NULL,"Last",16,(GtkPositionType) 1);
lastButton->SetTip("Goes to last record");
hbox16->Add(lastButton,0,1,1,0);
firstButton = new VDKCustomButton(this,(char*) NULL,"First",16,(GtkPositionType) 1);
firstButton->SetTip("Goes to first record");
hbox16->Add(firstButton,0,1,1,0);
delButton = new VDKCustomButton(this,(char*) NULL,"Delete",16,(GtkPositionType) 1);
delButton->SetTip("Deletes current record");
hbox16->Add(delButton,0,1,1,0);
undelButton = new VDKCustomButton(this,(char*) NULL,"Undel",16,(GtkPositionType) 1);
undelButton->SetTip("Undelete current record");
hbox16->Add(undelButton,0,1,1,0);
showdelButton = new VDKCustomButton(this,(char*) NULL,"Show del",32,(GtkPositionType) 1);
showdelButton->SetTip("Show deleted records");
hbox16->Add(showdelButton,0,1,1,0);
updateButton = new VDKCustomButton(this,(char*) NULL,"Update",16,(GtkPositionType) 1);
updateButton->SetTip("Updates current record");
hbox16->Add(updateButton,0,1,1,0);
addButton = new VDKCustomButton(this,(char*) NULL,"Add",16,(GtkPositionType) 1);
addButton->SetTip("Add a record");
hbox16->Add(addButton,0,1,1,0);
orderButton = new VDKCustomButton(this,(char*) NULL,"Switch order",16,(GtkPositionType) 1);
orderButton->SetTip("Switches between indexes");
hbox16->Add(orderButton,0,1,1,0);
quitButton = new VDKCustomButton(this,"mini-cross.xpm","_Quit",16,(GtkPositionType) 1);
quitButton->SetTip("Quit program");
hbox16->Add(quitButton,0,1,1,0);
notebook_page1 = new VDKBox(this,v_box);
notebook->AddPage(notebook_page1,"VDKXDBCustomList");
char* fieldListTitles[] = { "First name","Last name","Birth date","Sex","Amount","Of Age" };
fieldList = new VDKXCustomList(this,6,fieldListTitles,(GtkSelectionMode) 0);
fieldList->SetSize(100,100);
fieldList->AutoResize = true;
notebook_page1->Add(fieldList,0,1,1,0);
#ifdef VDKXDB_SUPPORT
{
VDKString dbname;
TestxdbApp* app = dynamic_cast<TestxdbApp*>(Application());
dbname = XDB_DATA_PATH;
dbname += "myfamily.dbf";
if(app && app->TheXdb())
{
fieldList->AssignTableFieldToColumn(0,app->TheXdb(),(char*) dbname,"FIRSTNAME");
fieldList->AssignTableFieldToColumn(1,app->TheXdb(),(char*) dbname,"LASTNAME");
fieldList->AssignTableFieldToColumn(2,app->TheXdb(),(char*) dbname,"BIRTHDATE");
fieldList->AssignTableFieldToColumn(3,app->TheXdb(),(char*) dbname,"SEX");
fieldList->AssignTableFieldToColumn(4,app->TheXdb(),(char*) dbname,"HOWMANY");
fieldList->AssignTableFieldToColumn(5,app->TheXdb(),(char*) dbname,"OFAGE");
}
}
#endif
}

/*
VDKXDatabase setup
Initializes all tables and indexes contained into
testxdb.prj.xdb
and open tables if marked as active.
Notes:
- all path to tables and indexes files
are relative to XDB_DATA_PATH symbolic constant,
change it into testxdb.h header file if you need
a different path, all data files should be contained
into a single directory however
- method will be empty if no tables are used
*/

#ifdef VDKXDB_SUPPORT
void
TestxdbApp::XDBSetup(void)
{
VDKXTable* table = NULL;
VDKXTableIndex* index = NULL;
VDKString dbname;
VDKString ndxname;
dbname = XDB_DATA_PATH;
dbname += "myfamily.dbf";
table = new VDKXTable(xdb,(char*) dbname);
if(table) table->Open();
ndxname = XDB_DATA_PATH;
ndxname += "birthday.ndx";
index = new VDKXTableIndex(table,(char*) ndxname);
if(index) index->Open();
ndxname = XDB_DATA_PATH;
ndxname += "name.ndx";
index = new VDKXTableIndex(table,(char*) ndxname);
if(index) index->Open();
if(index && table && table->IsOpen())
    table->Order = 0;
if(table && table->IsOpen())
    table->First();
}
#endif

// do not remove this mark: #!#
// end of file:testxdb_gui.cc