/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
/*
 * Dirtree widget is a part of GTK See distribution, which
 * is under GPL version 2.
 * Original author: Hotaru Lee <hotaru@163.net>
 */
#include "vdk/FileTreeDialog.h"
extern "C"
{
#include <unistd.h>
#include <sys/types.h>
//#include <sys/dir.h> 
#include <dirent.h>
#include <sys/stat.h>
#include <string.h>
}
 
#define LIST_COLS 1

extern char* folder_xpm[];
extern char* folder_open_xpm[];
static char *titles[] = {"Files","Length","Time stamp",NULL};
// extensions
extern char* c_xpm[];
extern char* file_xpm[];
extern char* xpm_xpm[]; 
extern char* text_xpm[];
extern char* gif_xpm[];
extern char* h_xpm[]; 
extern char* tgz_xpm[];
extern char* html_xpm[];
extern char* exec_xpm[];
extern char* link_xpm[];
extern char* socket_xpm[];
inline bool is_hidden(char* s)
{
  return *s == '.' ;//&& strcmp(s,"../") && strcmp(s,"./");
}
/////////////////////////////////////////
//
////////////////////////////////////////
DEFINE_SIGNAL_MAP(VDKFileTreeDialog, VDKForm)
  ON_SIGNAL(open,clicked_signal,OpenClick),
  ON_SIGNAL(cancel,clicked_signal,CancelClick),
  ON_SIGNAL(hiddenCb,toggled_signal,ToggleHidden),
  ON_SIGNAL(filelist,select_row_signal,OpenClick)
END_SIGNAL_MAP
////////////////////////////////////
//
////////////////////////////////////
VDKFileTreeDialog::VDKFileTreeDialog(
			     VDKForm* owner,
			     FileStringArray* selections,
			     char* title, 
			     GtkWindowType display):
  VDKForm(owner,title,display),selections(selections)
{ 
  char wd[256];
  VDKBox* listbox = new VDKBox(this,h_box);
  /* creating dirtree */
  getcwd(wd, 256);
  treewin = new VDKScrolled(this);
  gtk_widget_set_usize(treewin->Widget(),200,250);
  gtk_container_border_width(GTK_CONTAINER(treewin->Widget()),1);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(treewin->Widget()),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  VDKObject* treeobj = new VDKObject(this,
				     tree = dirtree_new_by_dir(window, wd));
  treewin->AddWithViewport(treeobj);
  gtk_signal_connect(GTK_OBJECT(tree), 
		     "selection_changed", 
		     GTK_SIGNAL_FUNC(VDKFileTreeDialog::SelectionChanged), 
		     reinterpret_cast<gpointer>(this));
  listbox->Add(treewin);
  //
  listbox->Add(new VDKSeparator(this,v_separator),l_justify,false);
  VDKBox *filebox = new VDKBox(this);
  VDKBox* labelbox = new VDKBox(this,h_box);
  VDKPixmap* dirpix = new VDKPixmap(this,folder_open_xpm);
  labelbox->Add(dirpix,l_justify);
  getcwd(wd, 256); 
  dir_label = new VDKEntry(this,0,wd);
  labelbox->Add(dir_label);
  dir_label->Editable = false;
  filebox->Add(labelbox,l_justify,FALSE,FALSE,0);
  filelist = new VDKCustomSortedList(this,0,LIST_COLS,
			       titles,GTK_SELECTION_EXTENDED);
 
  filelist->SetSize(200,250);
  filelist->ActiveTitles(false);
  filelist->PrelightBackground = clWhite;
  filebox->Add(filelist);
  listbox->Add(filebox);
  Add(listbox);
  Add(new VDKSeparator(this,h_separator),l_justify,false);
  VDKTable *table = new VDKTable(this,2,3);
  hiddenCb =  
    new VDKCheckButton(this,
		       "Shows hidden files");
  table->Add(hiddenCb,0,1,0,1);
  open = new VDKLabelButton(this,"Open");
  cancel = new VDKLabelButton(this,"Cancel");
  table->Add(open,2,3,0,1);
  table->Add(cancel,2,3,1,2);
  Add(table); 
}

/*
all response method goes here 
*/

//////////////////////////////////////
//
//////////////////////////////////////
void VDKFileTreeDialog::OnShow(VDKForm*)
{
   char wd[256];
   getcwd(wd, 256);
   LoadDir(wd);//DIRTREE(tree)->selected_dir); 
   Adjust(wd);
}
////////////////////////////////////////

void VDKFileTreeDialog::Adjust(char* dir)
{
  /*
   vadj = gtk_scrolled_window_get_vadjustment(
		      GTK_SCROLLED_WINDOW(treewin->Widget()));
   gint y = DIRTREE(tree)->item_height;
   gint y1 = dirtree_select_dir(GTK_TREE(tree), dir);
   gtk_adjustment_set_value(vadj, y * y1);
  */
  vadj = gtk_scrolled_window_get_vadjustment(
		     GTK_SCROLLED_WINDOW(treewin->Widget()));
  float range = vadj->upper-vadj->lower;
  float factor = DIRTREE(tree)->item_height;
  float scroll = (vadj->lower + range*factor)*0.5;
  gtk_adjustment_set_value(vadj,scroll);
}
///////////////////////////////////////
void VDKFileTreeDialog::SelectionChanged(GtkWidget* dt, gpointer gp)
{

  VDKFileTreeDialog* form = reinterpret_cast<VDKFileTreeDialog*>(gp);
  form->dir_label->Text = DIRTREE(dt)->selected_dir;
  form->LoadDir(DIRTREE(dt)->selected_dir);
  form->Adjust(DIRTREE(dt)->selected_dir);
}

////////////////////////////////////////
//
////////////////////////////////////////
void VDKFileTreeDialog::LoadDir(char* dir)
{
  DIR *dp;
  //struct direct *item;
  struct dirent *item;
  char fullname[256];    
  char* name;
  struct stat st;
  if ((dp = opendir(dir)) == NULL) return;
  filelist->Clear();
  filelist->Freeze();
  while ((item = readdir(dp)) != NULL)
	{
	  if (item -> d_ino == 0) continue;
	  if (strcmp(item -> d_name, ".") == 0) continue;
	  if (strcmp(item -> d_name, "..") == 0) continue;
	  strcpy(fullname, dir);
	  if (fullname[strlen(fullname) - 1] != '/') strcat(fullname,"/");
	  strcat(fullname, item -> d_name);
	  stat(fullname, &st);
	  if ((st.st_mode & S_IFMT) != S_IFREG) continue;
	  name = item -> d_name;
	  if(!is_hidden(name) || hiddenCb->Checked)
	    filelist->AddKey(&name,GetFileIcon(name));
	}
  closedir(dp);
  filelist->Thaw();
}
/*
 */
#define SUFFIX(str, suf) (strstr(str,suf)>0)
char** VDKFileTreeDialog::GetFileIcon(char* name)
{
  if (SUFFIX(name,".a")|| SUFFIX(name,".so"))
    return exec_xpm;
  //else if (SUFFIX(name,".c") || SUFFIX(name,".cc"))
  //return c_xpm;
  else if (SUFFIX(name,".tgz") || 
	   SUFFIX(name,".gz") || 
	   SUFFIX(name,".tar"))
    return tgz_xpm;
  //else if (SUFFIX(name,".h"))
  //return h_xpm;
  else if (SUFFIX(name,".html") || SUFFIX(name,".htm"))
    return html_xpm;
  else 
    return NULL;
}


/*
 */
bool VDKFileTreeDialog::ToggleHidden(VDKObject*)
{
  // reload present dir 
  LoadDir(DIRTREE(tree)->selected_dir);
  return true;
}

/*
 */
bool VDKFileTreeDialog::OpenClick(VDKObject*)
{
  char buff[256];
  int v = filelist->Selections().size();
  int j;
  if(v > 0)
    {
      selections->resize(filelist->Selections().size());
      int t;
      for( t=0; t < selections->size();t++)
	{ 
	  int row = filelist->Selections()[t];
	  sprintf(buff,"%s/%s",
		  DIRTREE(tree)->selected_dir,
		  (char*) filelist->Tuples[row][0]);
	  VDKString s(buff);
	  (*selections)[t] = s;
	}
    }
  else
    {
      j = filelist->Selected.Row();
      if(j >= 0)
	{
	  selections->resize(1);
	  sprintf(buff,"%s/%s",
		  DIRTREE(tree)->selected_dir,
		  (char*) filelist->Tuples[j][0]);
	  VDKString s(buff);
	  (*selections)[0] = s;
	}
      else
	selections->resize(0);
    }
  if(isModal) 
    Close();
return true;  
}
/*
 */
bool VDKFileTreeDialog::CancelClick(VDKObject*)
{
selections->resize(0);
Close();
return true;
}







