/*
   Keyboard functions
   --------------------------------------------------------------------
   VCHE - Virtual Console Hex Editor

   Copyright (C) 1998, 1999 Diego Javier Grigna <diego@grigna.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "common.h"

#if defined(VCHE_VC) || defined(VCHE_RAW)

void key_wait_for_any( void)
{
 term_raw();
 getc( stdin);
}

void key_scanf( char *str, int leng)
{
 int len = 0;
 int c;

 term_color( VC_COLOR_WHITE);

 term_unhide_cursor();
 fflush( stdout);

 while( 1) {
        c = key_get();

        switch( c) {
                case VC_KEY_LEFT : len--;
                                   if( len < 0) {
                                       term_beep();
                                       len = 0;
                                       continue;
                                   }
                                   printf( "\033[D");
                                   continue;
                case VC_KEY_RIGHT: if( str[ len] == 0)
                                       str[ len] = ' ';
                                   if( len == leng - 1 ) {
                                       term_beep();
                                       continue;
                                   }
                                   len++;
                                   printf( "\033[C");
                                   continue;
                case '\n':
                case '\r': term_hide_cursor();
                           term_color( VC_COLOR_OFF);
                           return;
                case 8   : 
                case 127 : len--;
                           if( len < 0) {
                               term_beep();
                               len = 0;
                               continue;
                           }
                           printf( "\033[D \033[D");
                           str[ len] = ' ';
                           continue;
        }

        if( len == leng - 1 ) {
            term_beep();
            continue;
        }

        if( c != 127 && !( c >= 0 && c <= 31)) {
            str[ len] = ( char) c;
            putchar( ( char) c);
            if( len < leng - 1) len++;
        }
 } /* end while */

}

int key_get( void)
{
 int c;

 c = getc( stdin);

 if( c != 27)
     return c;

 c = getc( stdin);

 /*
  * This may work on linux, vt100 and xterm terminals
  * I don't want to use termcap/terminfo/etc, if you want
  * something more compatible use the NCURSES version.
  */

 if( c == 'O' || c == '[' || c == '^') {
     c = getc( stdin);

     if( c == 0)
         return VC_KEY_HOME; /* On color_xterm */

     if( c == 'e') return VC_KEY_END; /* On color_xterm */

     if( c == 'A') return VC_KEY_UP;    /* UP ARROW KEY    */
     if( c == 'B') return VC_KEY_DOWN;  /* DOWN ARROW KEY  */
     if( c == 'C') return VC_KEY_RIGHT; /* RIGHT ARROW KEY */
     if( c == 'D') return VC_KEY_LEFT;  /* LEFT ARROW KEY  */

     if( c == 'H') return VC_KEY_HOME;  /* on xterm */
     if( c == 'F') return VC_KEY_END;   /* on xterm */

     if( c == 'P') return VC_KEY_F1;    /* F1 on xterm terminals */
     if( c == 'Q') return VC_KEY_F2;    /* F2 on xterm           */
     if( c == 'R') return VC_KEY_F3;    /* F3 on xterm           */
     if( c == 'S') return VC_KEY_F4;    /* F4 on xterm           */

     if( c == 't') return  VC_KEY_F5;   /*  F5 on vt100 */
     if( c == 'u') return  VC_KEY_F6;   /*  F6 on vt100 */
     if( c == 'v') return  VC_KEY_F7;   /*  F7 on vt100 */
     if( c == 'l') return  VC_KEY_F8;   /*  F8 on vt100 */
     if( c == 'w') return  VC_KEY_F9;   /*  F9 on vt100 */
     if( c == 'x') return VC_KEY_F10;   /* F10 on vt100 */

     if( c == '[') {
         c = getc( stdin);
         if( c == 'A') return VC_KEY_F1;
         if( c == 'B') return VC_KEY_F2;
         if( c == 'C') return VC_KEY_F3;
         if( c == 'D') return VC_KEY_F4;
         if( c == 'E') return VC_KEY_F5;
     }

     if( c == '1') {
         c = getc( stdin);
         if( c == '~')    return VC_KEY_HOME; /* HOME KEY */

         if( c == '1') { /* F1 on xterm */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F1;
         }
         if( c == '2') { /* F2 on xterm */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F2;
         }
         if( c == '3') { /* F3 on xterm */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F3;
         }
         if( c == '4') { /* F4 on xterm */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F4;
         }
         if( c == '5') { /* F5 on xterm */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F5;
         }
         if( c == '7') { /* F6 on linux an xterm terminals */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F6;
         }
         if( c == '8') { /* F7 */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F7;
         }
         if( c == '9') { /* F8 */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F8;
         }
     }

     if( c == '2') {
         c = getc( stdin);
         if( c == '0') { /* F9 */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F9;
         }
         if( c == '1') { /* F10 */
             c = getc( stdin);
             if( c == '~') return VC_KEY_F10;
         }
     }

     if( c == '4') {
         c = getc( stdin);
         if( c == '~') return VC_KEY_END;  /* END KEY  */
     }

     if( c == '5') {
         c = getc( stdin);
         if( c == '~') return VC_KEY_PGUP; /* PGUP KEY */
     }

     if( c == '6') {
         c = getc( stdin);
         if( c == '~') return VC_KEY_PGDN; /* PGDN KEY */
     }

     if( c == '7') {
         c = getc( stdin);
         if( c == '~') return VC_KEY_HOME; /* HOME on rxvt */
     }

     if( c == '8') {
         c = getc( stdin);
         if( c == '~') return VC_KEY_END;  /* END on rxvt */
     }

 } /* end if( c == 'O' || c == '[' || c == '^') */

 return VC_KEY_NONE;
}

#elif defined( VCHE_NC)

void key_scanf( WINDOW *w, char *str, int leng)
{
 term_unhide_cursor();

 echo();
 wgetnstr( w, str, leng);
 noecho();

 term_hide_cursor();
}

#endif

