/***************************************************************************
                          dcoptions.h  -  description
                             -------------------
    begin                : Sun Feb 24 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCOPTIONS_H
#define DCOPTIONS_H

/**
  *@author Mathias Kster
  */

#include <dcconfig.h>
#include <DCDialogOptions.h>

#include <qhttp.h>

class DCOptions : public DCDialogOptions  {
Q_OBJECT

public:
	/** construtor */
	DCOptions();
	/** destructor */
	virtual ~DCOptions();

	/** */
	void InitDocument();
	/** */
	void SetValues();
	/** */
	void GetValues();

private:
	/** */
	void BrowseSoundFile(eUserSound);
	/** */
	void PreviewSoundFile(eUserSound);
	/** */
	void SaveSharedFolders();
	/** */
	void SaveUserMenuCommands();
	/** */
	void SaveUserChatCommands();
	/** */
	void SaveAutoResponses();
	/** */
	void SetUserPhoto( QString filename );
	/** */
	void setupIconThemeComboBoxes();

	/** */
	QListViewItem * plviDCGUI;
	/** */
	QListViewItem * plviDCGUIIdentify;
	/** */
	QListViewItem * plviConnection;
	/** */
	QListViewItem * plviConnectionMode;
	/** */
	QListViewItem * plviConnectionSettings;
	/** */
	QListViewItem * plviTransfer;
	/** */
	QListViewItem * plviTransferFolder;
	/** */
	QListViewItem * plviTransferSettings;
	/** */
	QListViewItem * plviGUI;
	/** */
	QListViewItem * plviGUIUser;
	/** */
	QListViewItem * plviGUIChat;
	/** */
	QListViewItem * plviGUICommands;
	/** */
	QListViewItem * plviGUIMenus;
	/** */
	QListViewItem * plviGUITransfer;
	/** */
	QListViewItem * plviGUIGeneral;
	/** */
	QListViewItem * plviGUIIcons;
	/** */
	QListViewItem * plviGUIFilelistBrowser;
	/** */
	QListViewItem * plviSound;
	/** */
	QListViewItem * plviSoundGeneral;
	/** */
	QListViewItem * plviSoundFiles;
	/** */
	QListViewItem * plviLog;
	/** */
	QListViewItem * plviOther;
	/** */
	QListViewItem * plviSecurity;
	/** List view item for auto responses tab */
	QListViewItem * plviAutoResponse;
	/** List view item for encoding tab */
	QListViewItem * plviEncoding;
	/** QHttp for getting external IP */
	QHttp * http;

private slots:
	/** */
	void slotBrowseSoundFileConnect();
	/** */
	void slotBrowseSoundFileDisconnect();
	/** */
	void slotBrowseSoundFileSend();
	/** */
	void slotBrowseSoundFileReceive();
	/** */
	void slotBrowseSoundFileFirstReceive();
	/** */
	void slotBrowseSoundFileNickMentioned();

	/** */
	void slotLogChatEnableLogging();
	/** */
	void slotLogChatEnableNickNameFilter();
	/** */
	void slotLogChatAddNickNameFilter();
	/** */
	void slotLogChatDelNickNameFilter();

	/** */
	void slotDisableSound();
	/** */
	void slotExternalPlayer();
	/** */
	void slotSoundPlayConnect();
	/** */
	void slotSoundPlayDisconnect();
	/** */
	void slotSoundPlaySend();
	/** */
	void slotSoundPlayRecieve();
	/** */
	void slotSoundPlayFirstReceive();
	/** */
	void slotSoundPlayNickMentioned();
	/** */
	void slotPreviewSoundFileConnect();
	/** */
	void slotPreviewSoundFileDisconnect();
	/** */
	void slotPreviewSoundFileSend();
	/** */
	void slotPreviewSoundFileReceive();
	/** */
	void slotPreviewSoundFileFirstReceive();
	/** */
	void slotPreviewSoundFileNickMentioned();

	/** */
	void slotBrowseSoundPlayer();
	/** */
	void slotBrowseDownloadFolder();
	/** */
	void slotBrowseDownloadFinishedFolder();
	/** */
	void slotBrowseShareList();
	/** */
	void slotBrowseDataFolder();
	/** */
	void slotAddSharedFolder();
	/** */
	void slotRemoveSharedFolder();
	/** */
	void slotEditSharedFolder();
	/** */
	void slotCreateShareList();
	/** */
	void slotShareListInfo();
	/** */
	void slotSave();
	/** */
	void slotModeActiveChange(bool);
	/** */
	void slotModePassiveChange(bool);
	/** */
	void slotIPHOSTNAMEChange(bool);
	/** */
	void slotINTERFACEChange(bool);
	/** */
	void slotTestHost();
	/** */
	void slotGetInterface();
	/** */
	void slotGetInternetIP();
	/** */
	void slotGotInternetIP( bool error );
	/** */
	void slotSetTheme();
	/** */
	void slotBrowseLanguageFile();
	/** */
	void slotSelectLanguage();
	/** */
	void slotBrowseAppFont();
	/** */
	void slotBrowseTransferCert();
	/** */
	void slotBrowseTransferKey();
	/** */
	void slotAddHubListUrl();
	/** */
	void slotEditHubListUrl();
	/** */
	void slotRemoveHubListUrl();
	/** */
	void slotBrowseLogFile();
	/** */
	void slotBrowseBrowser();
	/** */
	void slotListViewOptionCurrentChanged( QListViewItem * item );
	/** */
	void slotDoubleClickedChatColor(QListBoxItem *);
	/** */
	void slotAutoAwayMode();
	/** */
	void slotChangePhoto();
	/** */
	void slotEnableShowJoinsParts();
	/** */
	void slotContextMenuUserMenuCommands(QListViewItem * item, const QPoint & pos, int col);
	/** */
	void slotContextMenuUserChatCommands(QListViewItem * item, const QPoint & pos, int col);
	/** */
	void slotContextMenuAutoResponses(QListViewItem * item, const QPoint & pos, int col);
	/** */
	void slotDontShareDotFilesChanged();
	/** Generates a new key and certificate for SSL transfers */
	void slotGenerateKeyCert();
};

/** */
inline void DCOptions::slotBrowseSoundFileConnect()
{ BrowseSoundFile(eusCONNECT); }
/** */
inline void DCOptions::slotBrowseSoundFileDisconnect()
{ BrowseSoundFile(eusDISCONNECT); }
/** */
inline void DCOptions::slotBrowseSoundFileSend()
{ BrowseSoundFile(eusSEND); }
/** */
inline void DCOptions::slotBrowseSoundFileReceive()
{ BrowseSoundFile(eusRECEIVE); }
/** */
inline void DCOptions::slotBrowseSoundFileFirstReceive()
{ BrowseSoundFile(eusFIRSTRECEIVE); }
/** */
inline void DCOptions::slotBrowseSoundFileNickMentioned()
{ BrowseSoundFile(eusNICKMENTIONED); }
/** */
inline void DCOptions::slotPreviewSoundFileConnect()
{ PreviewSoundFile(eusCONNECT); }
/** */
inline void DCOptions::slotPreviewSoundFileDisconnect()
{ PreviewSoundFile(eusDISCONNECT); }
/** */
inline void DCOptions::slotPreviewSoundFileSend()
{ PreviewSoundFile(eusSEND); }
/** */
inline void DCOptions::slotPreviewSoundFileReceive()
{ PreviewSoundFile(eusRECEIVE); }
/** */
inline void DCOptions::slotPreviewSoundFileFirstReceive()
{ PreviewSoundFile(eusFIRSTRECEIVE); }
/** */
inline void DCOptions::slotPreviewSoundFileNickMentioned()
{ PreviewSoundFile(eusNICKMENTIONED); }

#endif
