/***************************************************************************
                          dchubfilter.cpp  -  description
                             -------------------
    begin                : Mit Okt 30 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

#include "dchubfilter.h"

DCHubFilter::DCHubFilter(QWidget *parent, const char *name ) : DCDialogHubFilter(parent,name)
{
	InitDocument();
}

DCHubFilter::~DCHubFilter()
{
}

/** */
void DCHubFilter::InitDocument()
{
	connect( PushButton_SAVE, SIGNAL(clicked()), this, SLOT(accept()) );
	connect( PushButton_CANCEL, SIGNAL(clicked()), this, SLOT(reject()) );
}

/** */
void DCHubFilter::Edit( DC_HubFilterObject * HubFilterObject )
{
	LineEdit_FILTERNAME->setText(HubFilterObject->m_sFilterName.Data());
	SpinBox_MINUSER->setValue(HubFilterObject->m_nUser);
	LineEdit_CONTAINS->setText(HubFilterObject->m_sContains.Data());
	CheckBox_NAME->setChecked(HubFilterObject->m_bName);
	CheckBox_SERVER->setChecked(HubFilterObject->m_bServer);
	CheckBox_DESCRIPTION->setChecked(HubFilterObject->m_bDescription);
}

/** */
void DCHubFilter::Get( DC_HubFilterObject * HubFilterObject )
{
	HubFilterObject->m_sFilterName  = LineEdit_FILTERNAME->text().ascii();
	HubFilterObject->m_nUser        = SpinBox_MINUSER->value();
	HubFilterObject->m_sContains    = LineEdit_CONTAINS->text().ascii();
	HubFilterObject->m_bName        = CheckBox_NAME->isChecked();
	HubFilterObject->m_bServer      = CheckBox_SERVER->isChecked();
	HubFilterObject->m_bDescription = CheckBox_DESCRIPTION->isChecked();
}
