/*
 * GLX Hardware Device Driver for SiS 6326
 * Copyright (C) 2000 Jim Duchek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Jim Duchek <jim@linuxpimps.com> */

#include "sis6326glx.h"



void sis6326Triangle( GLcontext *ctx, GLuint e0, GLuint e1, GLuint e2, GLuint pv )
{
	const struct vertex_buffer *VB;
	GLuint		*vertices;
	GLboolean	replace[3];
	GLfloat 	*w;
	GLfloat 	tmp;
	int i;
	int topbot;
	int addr;
	int color;
	int flatshade;
	GLfloat y0, y1, y2;
	GLfloat z0, z1, z2;
	GLfloat x0, x1, x2;
	GLfloat delt02, diffx02, diffy02, diffy12;
	GLfloat cull;
	GLfloat fact = 1.0 / 65536.0;
	int fifo;

	sis6326glx.c_triangles++;

	VB = ctx->VB;

	cull = ctx->backface_sign * (((VB->Win.data[e1][0] - VB->Win.data[e0][0]) * 
				     (VB->Win.data[e0][1] - VB->Win.data[e2][1])) +
				    ((VB->Win.data[e1][1] - VB->Win.data[e0][1]) * 
				     (VB->Win.data[e2][0] - VB->Win.data[e0][0])));
	if (cull < 0)
		return;
		
//	if (sis6326glx.sendTex == 2)
//		return;

	fifo = 13 + (sis6326glx.sendTex) ? 9 : 0;
	WAITFIFOEMPTY(fifo);
		
	vertices = sis6326glx.setupVertices;
	replace[0] = replace[1] = replace[2] = GL_TRUE;
	
	if ( (e0 < sis6326glx.setupMax) &&
	     (e1 < sis6326glx.setupMax) &&
	     (e2 < sis6326glx.setupMax)) {
		if (e0 == vertices[0]) {
			replace[0] = GL_FALSE;
		} else {
			vertices[0] = e0;
		}
		if (e1 == vertices[1]) {
			replace[1] = GL_FALSE;
		} else {
			vertices[1] = e1;
		}
		if (e2 == vertices[2]) {
			replace[2] = GL_FALSE;
		} else {
			vertices[2] = e2;
		}
	} else {
		vertices[0] = e0;
		vertices[1] = e1;
		vertices[2] = e2;
	}

	y0 = VB->Win.data[vertices[0]][1];
	y1 = VB->Win.data[vertices[1]][1];
	y2 = VB->Win.data[vertices[2]][1];

	if (y0 > y1) {
		if (y1 > y2) {
			// Y's are fine as they are
			x0 = VB->Win.data[vertices[0]][0];
			x1 = VB->Win.data[vertices[1]][0];
			x2 = VB->Win.data[vertices[2]][0];
			flatshade = S_PRIM_SHADEMODE_FLATBOT;
			topbot = S_PRIM_ATOP | S_PRIM_BMID | S_PRIM_CBOT;
		} else {
			if (y0 > y2) {
				topbot = S_PRIM_ATOP | S_PRIM_CMID | S_PRIM_BBOT;
				x0 = VB->Win.data[vertices[0]][0]; // y is fine
				x1 = VB->Win.data[vertices[2]][0]; y1 = VB->Win.data[vertices[2]][1];
				flatshade = S_PRIM_SHADEMODE_FLATMID;
			} else {
				topbot = S_PRIM_CTOP | S_PRIM_AMID | S_PRIM_BBOT;
				x0 = VB->Win.data[vertices[2]][0]; y0 = VB->Win.data[vertices[2]][1];
				x1 = VB->Win.data[vertices[0]][0]; y1 = VB->Win.data[vertices[0]][1];
				flatshade = S_PRIM_SHADEMODE_FLATTOP;
			}
			x2 = VB->Win.data[vertices[1]][0]; y2 = VB->Win.data[vertices[1]][1];
		}
	} else {
		if (y0 > y2) {
			flatshade = S_PRIM_SHADEMODE_FLATBOT;
			topbot = S_PRIM_BTOP | S_PRIM_AMID | S_PRIM_CBOT;
			x0 = VB->Win.data[vertices[1]][0]; y0 = VB->Win.data[vertices[1]][1];
			x1 = VB->Win.data[vertices[0]][0]; y1 = VB->Win.data[vertices[0]][1];
			x2 = VB->Win.data[vertices[2]][0];
		} else {
			if (y1 > y2) {
				flatshade = S_PRIM_SHADEMODE_FLATMID;
				topbot = S_PRIM_BTOP | S_PRIM_CMID | S_PRIM_ABOT;
				x0 = VB->Win.data[vertices[1]][0]; y0 = VB->Win.data[vertices[1]][1];
				x1 = VB->Win.data[vertices[2]][0]; y1 = VB->Win.data[vertices[2]][1];
			} else {
				flatshade = S_PRIM_SHADEMODE_FLATTOP;
				topbot = S_PRIM_CTOP | S_PRIM_BMID | S_PRIM_ABOT;
				x0 = VB->Win.data[vertices[2]][0]; y0 = VB->Win.data[vertices[2]][1];
				x1 = VB->Win.data[vertices[1]][0]; // y is fine
			}
			x2 = VB->Win.data[vertices[0]][0]; y2 = VB->Win.data[vertices[0]][1];
		}
	}
		
		
	if (x1 <= x0 && x1 <= x2) {
		topbot |= 0x80;
	} else if (x1 >= x0 && x1 >= x2) {
	} else {
		diffx02 = x0 - x2;
		diffy02 = y0 - y2;
		diffy12 = y1 - y2;
		
		delt02 = diffx02 / diffy02;
		tmp = x1 - (diffy12 * delt02 + x2);
	
		if (tmp > 0.0) {
			//nuttin
		} else {
			topbot |= 0x80;
		}
	}

	if ((ctx->TriangleCaps & DD_FLATSHADE)) {
		topbot |= flatshade;
	} else {
		topbot |= S_PRIM_SHADEMODE_GOURAUD;
	}

	topbot |= S_PRIM_TRI | S_PRIM_FIRE_ARGBC;
	

	OUTREG( SIS6326_TRI_PRIMSET, (topbot));

	addr = SIS6326_TRI_FIRST;
	
	for (i=0; i<3; i++) {
		GLfloat y,z;

		if (!replace[i]) {
			addr += SIS6326_TRI_DIFF;
			continue;
		}

		w = VB->Win.data[vertices[i]];
		z = (w[2] + 0.5) * fact;

		y = (GLfloat)sis6326DB->height - w[1];
		
		if (sis6326glx.sendSpec) {
			int spec;
			spec =  (VB->Spec[0][vertices[i]][3] << 24) |
				(VB->Spec[0][vertices[i]][0] << 16) |
				(VB->Spec[0][vertices[i]][1] << 8) |
				(VB->Spec[0][vertices[i]][2]);
			OUTREG( (addr + SIS6326_TRI_TSFS), spec);
		}

 		OUTREG( (addr + SIS6326_TRI_TSZ), *(int*)&z);
		OUTREG( (addr + SIS6326_TRI_TSX), *(int*)&w[0]);
		OUTREG( (addr + SIS6326_TRI_TSY), *(int*)&y);
		
		if (sis6326glx.sendTex) {
			GLfloat s, t, v, wc;
			if (VB->TexCoordPtr[0]->size > 3) {
				v = 1.0 / VB->TexCoordPtr[0]->data[vertices[i]][3];
				s = VB->TexCoordPtr[0]->data[vertices[i]][0] * v;
				t = VB->TexCoordPtr[0]->data[vertices[i]][1] * v;
				wc = w[3] * VB->TexCoordPtr[0]->data[vertices[i]][3];
			} else {
				s = VB->TexCoordPtr[0]->data[vertices[i]][0];
				t = VB->TexCoordPtr[0]->data[vertices[i]][1];
				wc = w[3];
			}
			if (wc > 1.0)
				wc = 1.0;
			
	 		OUTREG( (addr + SIS6326_TRI_TSU), *(int*)&s);
			OUTREG( (addr + SIS6326_TRI_TSV), *(int*)&t);
			OUTREG( (addr + SIS6326_TRI_TSW), *(int*)&wc);
		}
		
		if (!(ctx->TriangleCaps & DD_FLATSHADE)) {
			color = ((VB->Color[0]->data[vertices[i]][3] << 24) |
			(VB->Color[0]->data[vertices[i]][0] << 16) |
			(VB->Color[0]->data[vertices[i]][1] << 8) |
			(VB->Color[0]->data[vertices[i]][2]));
			OUTREG( (addr + SIS6326_TRI_TSARGB), color);
		}
		addr += SIS6326_TRI_DIFF;
	}
	
	if (!replace[2] & !(ctx->TriangleCaps & DD_FLATSHADE)) {
		color = ((VB->Color[0]->data[vertices[2]][3] << 24) |
			(VB->Color[0]->data[vertices[2]][0] << 16) |
			(VB->Color[0]->data[vertices[2]][1] << 8) |
			(VB->Color[0]->data[vertices[2]][2]));
		OUTREG( (SIS6326_TRI_FIRST + (SIS6326_TRI_DIFF * 2) + SIS6326_TRI_TSARGB), color);
	}

	if ((ctx->TriangleCaps & DD_FLATSHADE)) {
		color = ((VB->Color[0]->data[pv][3] << 24) |
		(VB->Color[0]->data[pv][0] << 16) |
		(VB->Color[0]->data[pv][1] << 8) |
		(VB->Color[0]->data[pv][2]));
		OUTREG( (SIS6326_TRI_FIRST + (SIS6326_TRI_DIFF * 2) + SIS6326_TRI_TSARGB), color);
	}
	
	OUTREGB(SIS6326_TRI_TEND, 0xFF);
}	

void sis6326Quad( GLcontext *ctx, GLuint e0, GLuint e1, GLuint e2, GLuint e3, GLuint pv )
{
	sis6326Triangle(ctx, e0, e1, e3, pv);
	sis6326Triangle(ctx, e1, e2, e3, pv);
}

