
#include <dlfcn.h>
#include <stdio.h>

#define GLX_SYM_NO_DEFINES
#include "glx_symbols.h"


static int any_error;
static void *my_dlsym(void *handle, const char *name)
{
   void *tmp = dlsym(handle, name);
   char *error;
   if ((error = dlerror()) != 0) {
      fputs(error, stderr);
      any_error = 1;
      return 0;
   }
   return tmp;
}

int sis6326HookServerSymbols( void *handle )
{
   glxsym.sisMMIOBase = my_dlsym(handle, "sisMMIOBase");	

   if (!any_error) 
      fprintf(stderr, "Sucessfully initialized SiS 6326 server symbols\n");

   return !any_error;
}

