#include "s3virgeglx.h"

void s3virgeLine( GLcontext *ctx, GLuint e0, GLuint e1, GLuint pv )
{
	const struct vertex_buffer *VB;
	GLfloat 	*v0, *v1;
	int ycnt, ystart;
	int dx, dy, dz, xdelt, xstart;
	int y0, y1, x0, x1, z0, z1;
	int zstart, zdelt;
	int fp, lp;
	GLubyte *col;

	VB = ctx->VB;

	if (VB->Win.data[e0][1] > VB->Win.data[e1][1]) {
		v0 = VB->Win.data[e1];
		v1 = VB->Win.data[e0];
	} else {
		v1 = VB->Win.data[e1];
		v0 = VB->Win.data[e0];
	}

	x0 = v0[0]; x1 = v1[0];
	y0 = s3virgeDB->height - v0[1]; 
	y1 = s3virgeDB->height - v1[1]; 
	z0 = v0[0]; z1 = v1[2];	

	

	dx = x0 - x1;
	dy = y0 - y1;
	dz = z0 - z1;
	
	if (dx != 0 && dy != 0) {
		xdelt = (((-dx) << 20)/dy);
	} else 
		xdelt = 0;
		
	if (dz != 0 && dy != 0) {
		zdelt = (((-dz) << 15)/dy);
	} else
		zdelt = 0;
		
	xstart = x0;
	zstart = z0;

	xstart = (xstart << 20);
	zstart = (zstart << 15);
	
	if (dy < abs(dx)) {
		if (xdelt != 0)
			xstart = xstart + (xdelt / 2);
		if (dx < 0)
			xstart = xstart + ((1 << 20) - 1);
	}
	
	ystart = y0;

	WAITFIFOEMPTY(6);
	
	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_DX), xdelt);
	
	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_XSTART), xstart);
	
	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_ZSTART), zstart);
	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_DZ), zdelt);
	
	col = &(VB->Color[0]->data[pv][0]);
	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_GS_BS), ((col[1] << 23) | (col[2] << 7)));
	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_AS_RS), (((col[3]) << 23) | (col[0] << 7)));

	WAITFIFOEMPTY(6);
	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_GBD), 0);
	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_ARD), 0);

	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_YSTART), ystart);	
	
	ycnt = y0 - y1 + 1;

	if (x0 > x1) {
		fp = x0;
		lp = x1;
		OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_XEND0_END1), ((fp << 16) | lp));
		OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_YCNT), ycnt);
	} else {
		fp = x1;
		lp = x0;
		OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_XEND0_END1), ((fp << 16) | lp));
		OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_3DLINE_YCNT), (ycnt | 0x80000000));
	}

	OUTREG( (S3VIRGE_3DLINE_REG | S3VIRGE_CMDSET), s3virgeglx.currentline_cmd);
}
