/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    John Carmack <johnc@idsoftware.com>
 */

/* $Id: mgatex.h,v 1.10 2000/03/20 09:14:33 johnc Exp $ */

#ifndef MGATEX_INC
#define MGATEX_INC

#include "mesaglx/types.h"

#include "mgacommon.h"
#include "mm.h"

#define MGA_TEXTURE_OBJECT_MAGIC 0x9a0b3fd2

#define MGA_TEX_MAXLEVELS 5

typedef struct mga_texture_object_s {
	hwUI32	magic;
	struct mga_texture_object_s *next;	/* driver global chain of textures */
	struct gl_texture_object *tObj;		/* mesa texture */
	mgaContextPtr ctx;
	
	PMemBlock	memBlock;		/* buffer for all miplevels */
	hwUI32		offsets[MGA_TEX_MAXLEVELS];    /* byte offsets from memblock */
	hwUI32		totalSize;		/* for adding to c_textureUtilization */
	
	int		texelBytes;
	
	hwUI32 		age;   			/* set to mgaglx.swapBufferCount when bound */
	int 		UsePalette;
	int		paletteOrg;		/* value for srcorg in palette loading blit */
	
	/* hardware register values */
	hwUI32		texBorderCol;
	hwUI32		texCtl;
	hwUI32		texCtl2;
	hwUI32		texFilter;
	hwUI32		texHeight;
	hwUI32		texWidth;
	hwUI32		texOrg;
	hwUI32		texOrg1;
	hwUI32		texOrg2;
	hwUI32		texOrg3;
	hwUI32		texOrg4;
} mgaTextureObject_t;

typedef mgaTextureObject_t *mgaTextureObjectPtr;

/* called to check for environment variable options */
void mgaInitTextureSystem( void );

/* called before allocating buffers in card memory */
void mgaFlushAllTextures( void );

/* called before a primitive is rendered to make sure the texture
state is properly setup and all needed textures are resident */
void mgaUpdateTextureState( GLcontext *ctx );


/* Driver functions which are called directly from mesa */

void mgaTexEnv( GLcontext *ctx, GLenum pname, const GLfloat *param );

void mgaTexImage( GLcontext *ctx, GLenum target,
		  struct gl_texture_object *tObj, GLint level,
		  GLint internalFormat,
		  const struct gl_texture_image *image );

void mgaTexSubImage( GLcontext *ctx, GLenum target,
		  struct gl_texture_object *tObj, GLint level,
		  GLint xoffset, GLint yoffset,
		  GLsizei width, GLsizei height,
		  GLint internalFormat,
		  const struct gl_texture_image *image );

void mgaTexParameter( GLcontext *ctx, GLenum target,
		      struct gl_texture_object *tObj,
		      GLenum pname, const GLfloat *params );

void mgaBindTexture( GLcontext *ctx, GLenum target,
		     struct gl_texture_object *tObj );

void mgaDeleteTexture( GLcontext *ctx, struct gl_texture_object *tObj );

void mgaUpdateTexturePalette( GLcontext *ctx, struct gl_texture_object *tObj );

GLboolean mgaIsTextureResident( GLcontext *ctx, struct gl_texture_object *t );

/* this is actually in mgacnvtex.c */
void mgaConvertTexture( hwUI32 *destPtr, int texelBytes,
			struct gl_texture_image *image,
			int x, int y, int width, int height );

/* mmx asm version of the above; in mgacnvtex_mmx.c */
#if defined(USE_MMX_ASM)
void mgaConvertTexture_mmx( hwUI32 *destPtr, int texelBytes,
			struct gl_texture_image *image,
			int x, int y, int width, int height );
#endif	/* mmx */

#endif	/* MGATEX_INC */
