/* non_render.h,v 1.1 1998/10/10 11:36:59 ripperda Exp */

/*
 * Mesa 3-D graphics library
 * Version:  3.0
 * Copyright (C) 1995-1998  Brian Paul
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/*
 * non_render.h,v
 * Revision 1.1  1998/10/10 11:36:59  ripperda
 * keep missing some of these new files..
 *
 */

#ifndef NON_RENDER_H
#define NON_RENDER_H


#include "glxlib.h"

GLboolean __glx_AreTexturesResident(GLsizei n, const GLuint *textureNames,
    GLboolean *residences);

void __glx_DeleteLists( GLuint list, GLsizei range);

void __glx_DeleteTextures(GLsizei n, const GLuint *textures);

void __glx_EndList();

void __glx_FeedbackBuffer(GLsizei size, GLenum type, GLfloat* buffer);

void __glx_FeedbackBuffer(GLsizei size, GLenum type, GLfloat* buffer);

void __glx_Finish();

void __glx_Flush();

GLuint __glx_GenLists(GLsizei range);

void __glx_GenTextures(GLsizei n, GLuint *textureNames);

void __glx_GetBooleanv( GLenum pname, GLboolean *params );

void __glx_GetClipPlane( GLenum plane, GLdouble *equation );

void __glx_GetDoublev(GLenum pname, GLdouble* params);

GLenum __glx_GetError();

void __glx_GetFloatv(GLenum pname, GLfloat* params);

void __glx_GetIntegerv(GLenum pname, GLint* params);

void __glx_GetLightfv( GLenum light, GLenum pname, GLfloat *params );

void __glx_GetLightiv( GLenum light, GLenum pname, GLint *params );

void __glx_GetMapdv( GLenum target, GLenum query, GLdouble *v );

void __glx_GetMapfv( GLenum target, GLenum query, GLfloat *v );

void __glx_GetMapiv( GLenum target, GLenum query, GLint *v );

void __glx_GetMaterialfv( GLenum face, GLenum pname, GLfloat *params );

void __glx_GetMaterialiv( GLenum face, GLenum pname, GLint *params );

void __glx_GetPixelMapfv( GLenum map, GLfloat *values );

void __glx_GetPixelMapuiv( GLenum map, GLuint *values );

void __glx_GetPixelMapusv( GLenum map, GLushort *values );

void __glx_GetTexGendv( GLenum coord, GLenum pname, GLdouble *params );

const GLubyte *__glx_GetString( GLenum name );

void __glx_GetTexEnvfv( GLenum target, GLenum pname, GLfloat *params );

void __glx_GetTexEnviv( GLenum target, GLenum pname, GLint *params );

void __glx_GetTexGenfv( GLenum coord, GLenum pname, GLfloat *params );

void __glx_GetTexGeniv( GLenum coord, GLenum pname, GLint *params );

void __glx_GetTexLevelParameterfv( GLenum target, GLint level,
                              GLenum pname, GLfloat *params );

void __glx_GetTexLevelParameteriv( GLenum target, GLint level,
                              GLenum pname, GLint *params );

void __glx_GetTexParameterfv( GLenum target, GLenum pname, GLfloat *params);

void __glx_GetTexParameteriv( GLenum target, GLenum pname, GLint *params );

GLboolean __glx_IsEnabled(GLenum cap);

GLboolean __glx_IsList(GLuint list);

GLboolean __glx_IsTexture(GLuint textureName);

void __glx_NewList( GLuint list, GLenum mode);

void __glx_PixelStoref( GLenum pname, GLfloat param);

void __glx_PixelStorei( GLenum pname, GLint param);

GLint __glx_RenderMode(GLenum mode);

void __glx_SelectBuffer(GLsizei size, GLuint* buffer);

void __glx_GetPolygonStipple( GLubyte *mask );

void __glx_GetTexImage( GLenum target, GLint level, GLenum format,
                   GLenum type, GLvoid *pixels );

void __glx_ReadPixels( GLint x, GLint y, GLsizei width, GLsizei height,
                  GLenum format, GLenum type, GLvoid *pixels );

void __glx_PushClientAttrib(GLbitfield mask);

void __glx_PopClientAttrib();

void __glx_GetPointerv( GLenum pname, GLvoid **params );

#endif



