/*
 * Copyright (C) 1997 Steven Parker
 * Copyright (C) 1998 Terence Ripperda
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _GLXPROTO_H_
#define _GLXPROTO_H_ 1

#include <X11/X.h>
#include <X11/Xfuncproto.h>
#include <X11/Xmd.h>

#define GLX_EXTENSION_NAME "GLX"
#define GLX_NUMBER_EVENTS 1
#define GLX_NUMBER_ERRORS 9

#define GLX_NOHW_STRING "GLX_no_accel"
#define GLX_TRY_DIRECT_STRING "GLX_utah_direct_0_2"

extern int __glxErrorBase;

#define GLXBadContext                 (__glxErrorBase + 0)
#define GLXBadContextState            (__glxErrorBase + 1)
#define GLXBadDrawable                (__glxErrorBase + 2)
#define GLXBadPixmap                  (__glxErrorBase + 3)
#define GLXBadContextTag              (__glxErrorBase + 4)
#define GLXBadCurrentWindow           (__glxErrorBase + 5)
#define GLXBadRenderRequest           (__glxErrorBase + 6)
#define GLXBadLargeRequest            (__glxErrorBase + 7)
#define GLXUnsupportedPrivateRequest  (__glxErrorBase + 8)

/* define Vendor Private opcodes here */

#define X_GLXDeleteTexturesSGI      12

/* These support direct rendering.  They are used only once it has
 * been determined that direct rendering is possible and desirable for
 * both parties (libGL and the X server).  
 */
#define X_GLXDirectPrivateStart    6100
#define X_GLXDirectPrivateEnd      (X_GLXDirectPrivateStart + 19)

/* These two must be common to all the drivers as they are used in libGL
 * once it is known that direct rendering is possible.
 */
#define X_GLXDirectGoDirect      (X_GLXDirectPrivateStart)
#define X_GLXDirectRelease       (X_GLXDirectPrivateStart+1)



/* main glx opcodes */

#define X_GLXRender		1
#define X_GLXRenderLarge	2
#define X_GLXCreateContext	3
#define X_GLXDestroyContext	4
#define X_GLXMakeCurrent	5
#define X_GLXIsDirect		6
#define X_GLXQueryVersion	7
#define X_GLXWaitGL		8
#define X_GLXWaitX		9
#define X_GLXCopyContext	10
#define X_GLXSwapBuffers	11
#define X_GLXUseXFont           12
#define X_GLXCreateGLXPixmap    13
#define X_GLXGetVisualConfigs   14
#define X_GLXDestroyGLXPixmap   15
#define X_GLXVendorPrivate      16
#define X_GLXVendorPrivateWithReply      17
#define X_GLXQueryServerString	19
#define X_GLXClientInfo		20 

/* GL Non-rendering commands that do not return pixel data */
#define X_GLXNewList            101
#define X_GLXEndList            102
#define X_GLXDeleteLists        103
#define X_GLXGenLists           104
#define X_GLXFeedbackBuffer     105
#define X_GLXSelectBuffer       106
#define X_GLXRenderMode         107
#define X_GLXFinish             108
#define X_GLXFlush              142
#define X_GLXPixelStoref        109
#define X_GLXPixelStorei        110
#define X_GLXReadPixels         111
#define X_GLXGetBooleanv        112
#define X_GLXGetClipPlane       113
#define X_GLXGetDoublev         114
#define X_GLXGetError           115
#define X_GLXGetFloatv          116
#define X_GLXGetIntegerv        117
#define X_GLXGetLightfv         118
#define X_GLXGetLightiv         119
#define X_GLXGetMapdv           120
#define X_GLXGetMapfv           121
#define X_GLXGetMapiv           122
#define X_GLXGetMaterialfv      123
#define X_GLXGetMaterialiv      124
#define X_GLXGetPixelMapfv      125
#define X_GLXGetPixelMapuiv     126
#define X_GLXGetPixelMapusv     127
#define X_GLXGetPolygonStipple  128
#define X_GLXGetString          129
#define X_GLXGetTexEnvfv        130
#define X_GLXGetTexEnviv        131
#define X_GLXGetTexGendv        132
#define X_GLXGetTexGenfv        133
#define X_GLXGetTexGeniv        134
#define X_GLXGetTexImage        135
#define X_GLXGetTexParameterfv  136
#define X_GLXGetTexParameteriv  137
#define X_GLXGetTexLevelParameterfv 138
#define X_GLXGetTexLevelParameteriv 139
#define X_GLXIsEnabled              140
#define X_GLXIsList                 141

#define X_GLXAreTexturesResident    143
#define X_GLXDeleteTextures         144
#define X_GLXGenTextures            145
#define X_GLXIsTexture              146



typedef CARD32 GLX_CONTEXT;
typedef CARD32 GLX_CONTEXT_TAG;
typedef CARD32 GLX_DRAWABLE;
typedef float FLOAT32;
typedef double FLOAT64;
typedef Pixmap PIXMAP;
typedef XID GLX_PIXMAP;
typedef VisualID VISUALID;

typedef struct xGLXGetVisualConfigsReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    CARD32 screen;
} xGLXGetVisualConfigsReq;
#define sz_xGLXGetVisualConfigsReq 8
typedef struct xGLXGetVisualConfigsReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 num_visuals;
    CARD32 num_props;
    CARD32 unused[4];
} xGLXGetVisualConfigsReply;

typedef struct xGLXIsDirectReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    GLX_CONTEXT context_tag;
} xGLXIsDirectReq;
#define sz_xGLXIsDirectReq 8
typedef struct xGLXIsDirectReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    BOOL is_direct;
    CARD8 unused[23];
} xGLXIsDirectReply;

typedef struct xGLXQueryVersionReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    CARD32 major_version;
    CARD32 minor_version;
} xGLXQueryVersionReq;
#define sz_xGLXQueryVersionReq 12
typedef struct xGLXQueryVersionReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 major_version;
    CARD32 minor_version;
    CARD32 unused[4];
} xGLXQueryVersionReply;

typedef struct xGLXQueryServerStringReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    CARD32 screen;
    CARD32 name;
} xGLXQueryServerStringReq;
#define sz_xGLXQueryServerStringReq 12
typedef struct xGLXQueryServerStringReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 unused;
    CARD32 n;
    CARD32 unused2[4];
} xGLXQueryServerStringReply;

typedef struct xGLXCreateContextReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    GLX_CONTEXT context;
    CARD32 visual;
    CARD32 screen;
    GLX_CONTEXT sharelist;
    BOOL direct;
    CARD8 unused[3];
} xGLXCreateContextReq;
#define sz_xGLXCreateContextReq 24

typedef struct xGLXCopyContextReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    GLX_CONTEXT source_context;
    GLX_CONTEXT dest_context;
    CARD32 mask;
    GLX_CONTEXT_TAG source_tag;
} xGLXCopyContextReq;
#define sz_xGLXCopyContextReq 20

typedef struct xGLXDestroyContextReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    GLX_CONTEXT context;
} xGLXDestroyContextReq;
#define sz_xGLXDestroyContextReq 8

typedef struct xGLXRenderReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
} xGLXRenderReq;
#define sz_xGLXRenderReq 8

typedef struct xGLXRenderLargeReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD16 request_number;
    CARD16 request_total;
    CARD32 data_bytes;
} xGLXRenderLargeReq;
#define sz_xGLXRenderLargeReq 16

typedef struct xGLXMakeCurrentReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    GLX_DRAWABLE drawable;
    GLX_CONTEXT context;
    GLX_CONTEXT_TAG old_context;
} xGLXMakeCurrentReq;
#define sz_xGLXMakeCurrentReq 16
typedef struct xGLXMakeCurrentReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    GLX_CONTEXT_TAG context_tag;
    CARD32	unused[5];
} xGLXMakeCurrentReply;

typedef struct xGLXClientInfoReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    CARD32 major_version;
    CARD32 minor_version;
    CARD32 stringlength;
} xGLXClientInfoReq;
#define sz_xGLXClientInfoReq 16

typedef struct xGLXSimpleReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
} xGLXSimpleReq;
#define sz_xGLXSimpleReq 8

typedef xGLXSimpleReq xGLXWaitGLReq;
#define sz_xGLXWaitGLReq sz_xGLXSimpleReq

typedef xGLXSimpleReq xGLXWaitXReq;
#define sz_xGLXWaitXReq sz_xGLXSimpleReq

typedef struct xGLXSimpleIntReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    INT32 data;
} xGLXSimpleIntReq;
#define sz_xGLXSimpleIntReq 12

typedef struct xGLXSimpleCardReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 data;
} xGLXSimpleCardReq;
#define sz_xGLXSimpleCardReq 12

typedef struct xGLXSimpleReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 unused[6];
} xGLXSimpleReply;

typedef struct xGLXSimpleCardReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 data;
    CARD32 unused[5];
} xGLXSimpleCardReply;

typedef struct xGLXSwapBuffersReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    GLX_DRAWABLE drawable;
} xGLXSwapBuffersReq;
#define sz_xGLXSwapBuffersReq 12

typedef struct xGLXUseXFontReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 font;
    CARD32 first;
    CARD32 count;
    CARD32 listbase;
} xGLXUseXFontReq;
#define sz_xGLXUseXFontReq 24

typedef struct xGLXCreateGLXPixmapReq {
    CARD8      reqType;
    CARD8      glx_opcode;
    CARD16     length;
    CARD32     screen;
    VISUALID   visual;
    PIXMAP     pixmap;
    GLX_PIXMAP glx_pixmap;
} xGLXCreateGLXPixmapReq;
#define sz_xGLXCreateGLXPixmapReq 20

typedef struct xGLXDestroyGLXPixmapReq {
    CARD8      reqType;
    CARD8      glx_opcode;
    CARD16     length;
    GLX_PIXMAP glx_pixmap;
} xGLXDestroyGLXPixmapReq;
#define sz_xGLXDestroyGLXPixmapReq 8

typedef struct xGLXNewListReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 list;
    CARD32 mode;
} xGLXNewListReq;
#define sz_xGLXNewListReq 16

typedef struct xGLXVendorPrivateReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    CARD32 opcode;
    GLX_CONTEXT_TAG context_tag;
} xGLXVendorPrivateReq;
#define sz_xGLXVendorPrivateReq 12
typedef struct xGLXVendorPrivateReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 data[6];
} xGLXVendorPrivateReply ;

typedef struct xGLXFeedbackBufferReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    INT32 size;
    CARD32 type;
} xGLXFeedbackBufferReq;
#define sz_xGLXFeedbackBufferReq 16

typedef struct xGLXSelectBufferReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    INT32 size;
} xGLXSelectBufferReq;
#define sz_xGLXSelectBufferReq 12

typedef struct xGLXDeleteListsReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 list;
    INT32 range;
} xGLXDeleteListsReq;
#define sz_xGLXDeleteListsReq 16

typedef xGLXSimpleReq xGLXEndListReq;
#define sz_xGLXEndListReq sz_xGLXSimpleReq

typedef struct xGLXReadPixelsReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    INT32 x;
    INT32 y;
    INT32 width;
    INT32 height;
    CARD32 format;
    CARD32 type;
    CARD8 swap_bytes;
    CARD8 lsb_first;
    CARD8 unused[2];
} xGLXReadPixelsReq;
#define sz_xGLXReadPixelsReq 36
typedef struct xGLXReadPixelsReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 unused[2];
    INT32 width;
    INT32 height;
    CARD32 unused2[2];
} xGLXReadPixelsReply;

typedef struct xGLXGetTexImageReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 target;
    INT32 level;
    CARD32 format;
    CARD32 type;
    CARD8 swap_bytes;
    CARD8 unused[3];
} xGLXGetTexImageReq;
#define sz_xGLXGetTexImageReq 28
typedef struct xGLXGetTexImageReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 unused[2];
    INT32 width;
    INT32 height;
    CARD32 unused2[2];
} xGLXGetTexImageReply;

typedef struct xGLXPixelStoreiReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 pname;
    INT32 param;
} xGLXPixelStoreiReq;
#define sz_xGLXPixelStoreiReq 16

typedef struct xGLXPixelStorefReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 pname;
    FLOAT32 param;
} xGLXPixelStorefReq;
#define sz_xGLXPixelStorefReq 16

typedef struct xGLXRenderModeReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 mode;
} xGLXRenderModeReq;
#define sz_xGLXRenderModeReq 12
typedef struct xGLXRenderModeReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    INT32 retval;
    CARD32 n;
    CARD32 newmode;
    CARD32 unused[3];
} xGLXRenderModeReply;


typedef xGLXSimpleReq xGLXFinishReq;
#define sz_xGLXFinishReq sz_xGLXSimpleReq
typedef xGLXSimpleReply xGLXFinishReply;

typedef xGLXSimpleReq xGLXFlushReq;
#define sz_xGLXFlushReq sz_xGLXSimpleReq

typedef xGLXSimpleIntReq xGLXGenListsReq;
#define sz_xGLXGenListsReq sz_xGLXSimpleIntReq
typedef xGLXSimpleCardReply xGLXGenListsReply;

typedef xGLXSimpleCardReq xGLXGetIntegervReq;
#define sz_xGLXGetIntegervReq sz_xGLXSimpleCardReq
typedef struct xGLXGetIntegervReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    INT32 unused1;
    INT32 n;
    INT32 singledata;
    CARD32 unused2[3];
} xGLXGetIntegervReply;

typedef xGLXSimpleReq xGLXGetErrorReq;
#define sz_xGLXGetErrorReq sz_xGLXSimpleReq
typedef xGLXSimpleCardReply xGLXGetErrorReply;

typedef xGLXSimpleCardReq xGLXGetBooleanvReq;
#define sz_xGLXGetBooleanvReq sz_xGLXSimpleCardReq
typedef struct xGLXGetBooleanvReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    INT32 unused1;
    INT32 n;
    BYTE singlebool;
    BYTE unused2[15];
} xGLXGetBooleanvReply;

typedef xGLXSimpleCardReq xGLXGetClipPlaneReq;
#define sz_xGLXGetClipPlaneReq sz_xGLXSimpleCardReq
typedef struct xGLXGetClipPlaneReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 unused[6];
} xGLXGetClipPlaneReply;

typedef xGLXSimpleCardReq xGLXGetStringReq;
#define sz_xGLXGetStringReq sz_xGLXSimpleCardReq
typedef struct xGLXGetStringReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    INT32 unused1;
    INT32 n;
    CARD32 unused2[4];
} xGLXGetStringReply;

typedef struct xGLXDeleteTexturesReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 n;
} xGLXDeleteTexturesReq;  
#define sz_xGLXDeleteTexturesReq 12

typedef xGLXDeleteTexturesReq xGLXAreTexturesResidentReq;
#define sz_xGLXAreTexturesResidentReq 12

typedef struct xGLXAreTexturesResidentReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 value;
    CARD32 unused[5];
#if 0
    CARD32 length2;
    CARD32 unused2[6];
#endif
} xGLXAreTexturesResidentReply;

typedef struct xGLXGenTexturesReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 n;
} xGLXGenTexturesReq; 
#define sz_xGLXGenTexturesReq 12
typedef struct xGLXGenTexturesReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 unused[6];
} xGLXGenTexturesReply;  

typedef struct xGLXIsTextureReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 texture;
} xGLXIsTextureReq ;
#define sz_xGLXIsTextureReq 12
typedef struct xGLXIsTextureReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 value;
    CARD32 unused[5];
} xGLXIsTextureReply;


typedef xGLXSimpleCardReq xGLXGetFloatvReq;
#define sz_xGLXGetFloatvReq sz_xGLXSimpleCardReq
typedef struct xGLXGetFloatvReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    INT32 unused1;
    INT32 n;
    FLOAT32 singledata;
    CARD32 unused2[3];
} xGLXGetFloatvReply;

typedef struct xGLXGetLightfvReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 light;
    CARD32 pname;
} xGLXGetLightfvReq;
#define sz_xGLXGetLightfvReq 16
typedef xGLXGetFloatvReply xGLXGetLightfvReply;

typedef struct xGLXGetPolygonStippleReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD8 lsb_first;
    CARD8 unused[3];
} xGLXGetPolygonStippleReq;
#define sz_xGLXGetPolygonStippleReq 12
typedef xGLXSimpleReply xGLXGetPolygonStippleReply;

typedef struct xGLXGetMaterialfvReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 face;
    CARD32 pname;
} xGLXGetMaterialfvReq;
#define sz_xGLXGetMaterialfvReq 16
typedef xGLXGetFloatvReply xGLXGetMaterialfvReply;

typedef xGLXSimpleCardReq xGLXGetDoublevReq;
#define sz_xGLXGetDoublevReq sz_xGLXSimpleCardReq
typedef struct xGLXGetDoublevReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    INT32 unused1;
    INT32 n;
    FLOAT64 singledata;
    CARD32 unused2[2];
} xGLXGetDoublevReply;

typedef struct xGLXGetMapdvReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 target;
    CARD32 query;
} xGLXGetMapdvReq;
#define sz_xGLXGetMapdvReq 16
typedef xGLXGetDoublevReply xGLXGetMapdvReply;

typedef xGLXGetMapdvReq xGLXGetMapfvReq;
#define sz_xGLXGetMapfvReq sz_xGLXGetMapdvReq
typedef xGLXGetFloatvReply xGLXGetMapfvReply;

typedef xGLXGetMapdvReq xGLXGetMapivReq;
#define sz_xGLXGetMapivReq sz_xGLXGetMapdvReq
typedef xGLXGetIntegervReply xGLXGetMapivReply;

typedef struct xGLXGetTexGendvReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 coord;
    CARD32 pname;
} xGLXGetTexGendvReq;
#define sz_xGLXGetTexGendvReq 16
typedef xGLXGetDoublevReply xGLXGetTexGendvReply;

typedef xGLXGetTexGendvReq xGLXGetTexGenfvReq;
#define sz_xGLXGetTexGenfvReq sz_xGLXGetTexGendvReq
typedef xGLXGetFloatvReply xGLXGetTexGenfvReply;

typedef xGLXGetTexGendvReq xGLXGetTexGenivReq;
#define sz_xGLXGetTexGenivReq sz_xGLXGetTexGendvReq
typedef xGLXGetIntegervReply xGLXGetTexGenivReply;

typedef struct xGLXGetTexParameterfvReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 target;
    CARD32 pname;
} xGLXGetTexParameterfvReq;
#define sz_xGLXGetTexParameterfvReq 16
typedef xGLXGetFloatvReply xGLXGetTexParameterfvReply;

typedef xGLXGetTexParameterfvReq xGLXGetTexParameterivReq;
#define sz_xGLXGetTexParameterivReq sz_xGLXGetTexParameterfvReq
typedef xGLXGetIntegervReply xGLXGetTexParameterivReply;

typedef struct xGLXGetTexLevelParameterfvReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    CARD32 target;
    INT32 level;
    CARD32 pname;
} xGLXGetTexLevelParameterfvReq;
#define sz_xGLXGetTexLevelParameterfvReq 20
typedef xGLXGetFloatvReply xGLXGetTexLevelParameterfvReply;

typedef xGLXGetTexLevelParameterfvReq xGLXGetTexLevelParameterivReq;
#define sz_xGLXGetTexLevelParameterivReq sz_xGLXGetTexLevelParameterfvReq
typedef xGLXGetIntegervReply xGLXGetTexLevelParameterivReply;

typedef xGLXGetLightfvReq xGLXGetLightivReq;
#define sz_xGLXGetLightivReq sz_xGLXGetLightfvReq
typedef xGLXGetIntegervReply xGLXGetLightivReply;

typedef xGLXGetMaterialfvReq xGLXGetMaterialivReq;
#define sz_xGLXGetMaterialivReq sz_xGLXGetMaterialfvReq
typedef xGLXGetIntegervReply xGLXGetMaterialivReply;

typedef xGLXSimpleCardReq xGLXGetPixelMapfvReq;
#define sz_xGLXGetPixelMapfvReq sz_xGLXSimpleCardReq
typedef xGLXGetFloatvReply xGLXGetPixelMapfvReply;

typedef xGLXSimpleCardReq xGLXGetPixelMapuivReq;
#define sz_xGLXGetPixelMapuivReq sz_xGLXSimpleCardReq
typedef struct xGLXGetPixelMapuivReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    INT32 unused1;
    INT32 n;
    CARD32 singledata;
    CARD32 unused2[3];
} xGLXGetPixelMapuivReply;

typedef xGLXSimpleCardReq xGLXGetPixelMapusvReq;
#define sz_xGLXGetPixelMapusvReq sz_xGLXSimpleCardReq
typedef struct xGLXGetPixelMapusvReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    INT32 unused1;
    INT32 n;
    CARD16 singledata;
    CARD16 unused2;
    CARD32 unused3[3];
} xGLXGetPixelMapusvReply;

typedef struct xGLXGetTexEnvfvReq {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length B16;
    GLX_CONTEXT_TAG context_tag;
    INT32 target;
    INT32 pname;
} xGLXGetTexEnvfvReq;
#define sz_xGLXGetTexEnvfvReq 16
typedef xGLXGetFloatvReply xGLXGetTexEnvfvReply;

typedef xGLXGetTexEnvfvReq xGLXGetTexEnvivReq;
#define sz_xGLXGetTexEnvivReq sz_xGLXGetTexEnvfvReq
typedef xGLXGetIntegervReply xGLXGetTexEnvivReply;

typedef xGLXSimpleCardReq xGLXIsEnabledReq;
#define sz_xGLXIsEnabledReq sz_xGLXSimpleCardReq
typedef xGLXSimpleCardReply xGLXIsEnabledReply;

typedef xGLXSimpleCardReq xGLXIsListReq;
#define sz_xGLXIsListReq sz_xGLXSimpleCardReq
typedef xGLXSimpleCardReply xGLXIsListReply;


/* Not quite sure where to put these 'hidden' protocol declarations.
 */
typedef struct xGLXDirectGoDirectPrivate {
    CARD8 reqType;
    CARD8 glx_opcode;
    CARD16 length;
    GLX_CONTEXT context;
} xGLXDirectGoDirectReq;


typedef struct xGLXDirectGoDirectReply {
    BYTE type;
    CARD8 xpad;
    CARD16 sequenceNumber;
    CARD32 length;
    CARD32 n;
} xGLXDirectGoDirectReply;


#endif /* _GLX_PROTO_H_ 1 */
