/*
    Copyright (C) 2001-2002  bjk <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <paths.h>
#include <string.h>
#include <ctype.h>
#include "common.h"

#ifdef USE_KVM
#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/user.h>
#include <kvm.h>

char *parentpid(INFO *info) 
{
    kvm_t *kd;
    char *err, *str, tmp[sizeof(info->login->idle)];
    int cnt, i;
    struct kinfo_proc *kp;

    err = str = NULL;

    if ((kd = kvm_openfiles(_PATH_DEVNULL, _PATH_DEVNULL, _PATH_DEVNULL,
		    O_RDONLY, err)) == NULL) {
	fprintf(stderr, "kvm: %s\n", err);
	return UNKNOWN;
    }

    if ((kp = kvm_getprocs(kd, KERN_PROC_RUID, info->passwd->pw_uid, &cnt))
	    == NULL){
	fprintf(stderr, "kvm: kvm_getprocs()\n");
        kvm_close(kd);
	return UNKNOWN;
    }


    if ((i = kp[0].kp_eproc.e_ppid) <= 1)
	str = UNKNOWN;
    else {
	tmp[0] = 0;
	strncpy(tmp, itoa(i), sizeof(tmp)); 
        str = tmp;
    }

    kvm_close(kd);
    return str;
}
#elif defined(HAVE_PROCFS)
char *parentpid(INFO *info) 
{
    FILE *fp;
    char *str;
    static int firstrun;
    int ppid;
    struct dirent *ent;
    struct stat mystat;

    if (!procdir && firstrun)
	return UNKNOWN;

    if (!procdir) {
	firstrun = 1;

	if ((procdir = opendir("/proc")) == NULL) {
	    perror("/proc");
	    return UNKNOWN;
	}
    }

    rewinddir(procdir);

    while ((ent = readdir(procdir)) != NULL) {
	int i;
	char filename[FILENAME_MAX];
	char buf[LINE_MAX], *t;

	if (!isdigit(*ent->d_name))
	    continue;

	filename[0] = 0;

#ifdef __linux__
	snprintf(filename, sizeof(filename), "/proc/%s/stat", ent->d_name);
#else
	snprintf(filename, sizeof(filename), "/proc/%s/status", ent->d_name);
#endif

	if (stat(filename, &mystat) == -1)
	    continue;

	if (mystat.st_uid == info->passwd->pw_uid) {
	    if ((fp = fopen(filename, "r")) == NULL)
		continue;

	    if ((t = fgets(buf, sizeof(buf), fp)) == NULL) {
		fclose(fp);
		continue;
	    }

#ifdef __linux__
	    if ((i = sscanf(buf, "%*i %*s %*c %*i %*i %i", &ppid)) < 1) {
#else
	    if ((i = sscanf(buf, "%*s %*i %i", &ppid)) < 1) {
#endif
		fclose(fp);
		continue;
	    }

	    fclose(fp);
	    break;
	}
    }

    if (ppid <= 1)
	str = UNKNOWN;
    else
	str = itoa(ppid);
    
    return str;
}
#endif
