/* Glyphs.

   Copyright (C) 2000 Daiki Ueno <ueno@unixuser.org>

   Author: Daiki Ueno <ueno@unixuser.org>
   Created: 2000-05-16

   This file is part of UltraPoint.

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)  
   any later version.                                                   

   This program is distributed in the hope that it will be useful,      
   but WITHOUT ANY WARRANTY; without even the implied warranty of       
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the        
   GNU General Public License for more details.                         

   You should have received a copy of the GNU General Public License    
   along with GNU Emacs; see the file COPYING.  If not, write to the    
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
   Boston, MA 02111-1307, USA.                                          

*/

#ifndef __UPT_GLYPH_H_
#define __UPT_GLYPH_H_

#include "font.h"

typedef struct _UptGlyph UptGlyph;
typedef struct _UptGlue UptGlue;

struct _UptGlue {
  /* cost values in variable condition */
  gint linewrap_cost;
  gint expand_cost;
  gint contract_cost;

  /* minimal length of the glue (in em) */
  gdouble min_width;
  /* minimal length of the glue (in em) */
  gdouble max_width;

  glong pixel_width;

  gint ref_count;
  GFreeFunc free;
};

struct _UptGlyph {
  /* pointer to the glyph on the left hand side */
  UptGlue *right_glue;

  /* internal use only --- for opened font descripter */
  UptFont *font;

  /* internal use only --- transformed codepoint */
  glong codepoint;

  VF_BITMAP bm;

  gint ref_count;
  GFreeFunc free;
};

UptGlue *upt_glue_new (gint linewrap_cost, gint expand_cost,
		       gint contract_cost, gdouble min_width,
		       gdouble max_width);

UptGlyph *upt_glyph_new (UptFont *font, glong codepoint);
void upt_glyph_instantiate (UptGlyph *glyph);
void upt_glyph_get_metric (UptGlyph *glyph, gint *bbx_width, gint *bbx_height,
			   gint *off_x, gint *off_y, gint *mv_x, gint *mv_y);

#endif
