/* ==================================================== ======== ======= *
 *
 *  umsflow.hpp : UMS event flow.
 *
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)umsflow.hpp	ubit:03.05.05"
#ifndef _umsflow_hpp_
#define	_umsflow_hpp_
#include "umserver.hpp"

/* ==================================================== ======== ======= */
/**
 * UMS event flow.
 */
class UMSeventFlow {
public:
  UMSeventFlow(class UMServer* ums, int flow_id);
  virtual ~UMSeventFlow();

  int getID() const {return id;}
  class UMServer& getUMS() const {return ums;}

  virtual Window getPointer() const {return None;}

protected:
  class UMServer& ums;
  int  id;
};

/* ==================================================== ======== ======= */
/**
 * UMS mouse event flow.
 */
class UMSmouseFlow : public UMSeventFlow {
public:
  UMSmouseFlow(class UMServer* ums, int flow_id, bool create_pointer);
  virtual ~UMSmouseFlow();

  void createPointer(const char* fgcolor_name = 0, const char* bgcolor_name = 0);
  /**< creates a mouse pointer on the screen.
   * NB: default color are black on white
   */

  void setPointer(const char* fgcolor_name, const char* bgcolor_name);

  virtual Window getPointer() const {return pointer_win;}

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

  void pressMouse(const UMSbuttonMapping*);
  void releaseMouse(const UMSbuttonMapping*);
  void pressMouse(u_int mouse_btn_maskid, u_int modifiers);
  void releaseMouse(u_int mouse_btn_maskid, u_int modifiers);
  ///< mouse_btn_maskid is ONE of Button1Mask, etc and must NOT be ORed.

  void moveMouse(int x, int y, bool absolute_coords);
  /**<
   *  - x and y are screen coordinates if 'absolute_coords' is true
   *    and relative translations from the previous position otherwise. 
   */

  void mouseMoved(int x, int y);
  ///< called by moveMouse() to send Motion and Crossing events.

  class UMSneighbor* checkBordersAndNeighbors(int& n_mx, int& n_my);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

  long getX() const {return mx;}
  long getY() const {return my;}

  long getState() const {return state_mask;}
  ///< returns mouse button mask BEFORE current action

  bool isPressed(long mouse_btn_maskid) const 
  {return (state_mask & mouse_btn_maskid) != 0;}
  ///< mouse_btn_maskid is a combination of Button1Mask, etc and can be ORed.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

protected:
  long mx, my;	     ///< mouse absolute pos
  long state_mask;   ///< mouse button mask before current action
  Window pointer_win;
  Window last_entered_win;
  bool last_entered_ptr_in_uwin;
  int last_entered_winsock;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
