/*  gtktiemu - a TI89/92/92+ emulator
 *  (c) Copyright 2000, Romain Lievin and Thomas Corvazier
 *  (c) Copyright 2001, Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TI68K_CALLBACKS__
#define __TI68K_CALLBACKS__

#ifdef __cplusplus
extern "C"{
#endif

  // Callbacks type
  typedef int  (*callback_iv_t) (void);
  typedef int  (*callback_ii_t) (int);
  typedef void (*callback_vi_t) (int);
  typedef void (*callback_vv_t) (void);

  extern callback_iv_t cb_launch_debugger;
  extern callback_vi_t cb_update_progbar;

  extern callback_iv_t cb_init_specific;
  extern callback_iv_t cb_exit_specific;
  extern callback_ii_t cb_set_contrast;
  extern callback_iv_t cb_update_screen;
  extern callback_iv_t cb_update_keys;
  extern callback_iv_t cb_screen_on;
  extern callback_iv_t cb_screen_off;
  extern callback_vi_t cb_set_screen_ptr;


#ifdef __cplusplus
}
#endif

#endif
