//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qapplication_c.h"

QApplicationH QApplication_create(int* argc, char** argv, int p3)
{
	return (QApplicationH) new QApplication(*(int*)argc, argv, p3);
}

void QApplication_destroy(QApplicationH handle)
{
	delete (QApplication *)handle;
}

QApplicationH QApplication_create2(int* argc, char** argv, bool GUIenabled, int p4)
{
	return (QApplicationH) new QApplication(*(int*)argc, argv, GUIenabled, p4);
}

QApplicationH QApplication_create3(int* argc, char** argv, QApplication::Type p3, int p4)
{
	return (QApplicationH) new QApplication(*(int*)argc, argv, p3, p4);
}

#if defined BINUX
QApplicationH QApplication_create4(Display* dpy, Qt::HANDLE visual, Qt::HANDLE cmap, int p4)
{
	return (QApplicationH) new QApplication(dpy, visual, cmap, p4);
}

QApplicationH QApplication_create5(Display* dpy, int* argc, char** argv, Qt::HANDLE visual, Qt::HANDLE cmap, int p6)
{
	return (QApplicationH) new QApplication(dpy, *(int*)argc, argv, visual, cmap, p6);
}

#endif
QApplication::Type QApplication_type()
{
	return (QApplication::Type) QApplication::type();
}

QStyleH QApplication_style()
{
	return (QStyleH) QApplication::style();
}

void QApplication_setStyle(QStyleH p1)
{
	QApplication::setStyle((QStyle*)p1);
}

QStyleH QApplication_setStyle2(PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	return (QStyleH) QApplication::setStyle(t_p1);
}

int QApplication_colorSpec()
{
	return (int) QApplication::colorSpec();
}

void QApplication_setColorSpec(int p1)
{
	QApplication::setColorSpec(p1);
}

void QApplication_setGraphicsSystem(PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	QApplication::setGraphicsSystem(t_p1);
}

QCursorH QApplication_overrideCursor()
{
	return (QCursorH) QApplication::overrideCursor();
}

void QApplication_setOverrideCursor(const QCursorH p1)
{
	QApplication::setOverrideCursor(*(const QCursor*)p1);
}

void QApplication_changeOverrideCursor(const QCursorH p1)
{
	QApplication::changeOverrideCursor(*(const QCursor*)p1);
}

void QApplication_restoreOverrideCursor()
{
	QApplication::restoreOverrideCursor();
}

void QApplication_palette(QPaletteH retval)
{
	*(QPalette *)retval = QApplication::palette();
}

void QApplication_palette2(QPaletteH retval, const QWidgetH p1)
{
	*(QPalette *)retval = QApplication::palette((const QWidget*)p1);
}

void QApplication_palette3(QPaletteH retval, const char* className)
{
	*(QPalette *)retval = QApplication::palette(className);
}

void QApplication_setPalette(const QPaletteH p1, const char* className)
{
	QApplication::setPalette(*(const QPalette*)p1, className);
}

void QApplication_font(QFontH retval)
{
	*(QFont *)retval = QApplication::font();
}

void QApplication_font2(QFontH retval, const QWidgetH p1)
{
	*(QFont *)retval = QApplication::font((const QWidget*)p1);
}

void QApplication_font3(QFontH retval, const char* className)
{
	*(QFont *)retval = QApplication::font(className);
}

void QApplication_setFont(const QFontH p1, const char* className)
{
	QApplication::setFont(*(const QFont*)p1, className);
}

void QApplication_fontMetrics(QFontMetricsH retval)
{
	*(QFontMetrics *)retval = QApplication::fontMetrics();
}

void QApplication_setWindowIcon(const QIconH icon)
{
	QApplication::setWindowIcon(*(const QIcon*)icon);
}

void QApplication_windowIcon(QIconH retval)
{
	*(QIcon *)retval = QApplication::windowIcon();
}

QDesktopWidgetH QApplication_desktop()
{
	return (QDesktopWidgetH) QApplication::desktop();
}

QWidgetH QApplication_activePopupWidget()
{
	return (QWidgetH) QApplication::activePopupWidget();
}

QWidgetH QApplication_activeModalWidget()
{
	return (QWidgetH) QApplication::activeModalWidget();
}

QClipboardH QApplication_clipboard()
{
	return (QClipboardH) QApplication::clipboard();
}

QWidgetH QApplication_focusWidget()
{
	return (QWidgetH) QApplication::focusWidget();
}

QWidgetH QApplication_activeWindow()
{
	return (QWidgetH) QApplication::activeWindow();
}

void QApplication_setActiveWindow(QWidgetH act)
{
	QApplication::setActiveWindow((QWidget*)act);
}

QWidgetH QApplication_widgetAt(const QPointH p)
{
	return (QWidgetH) QApplication::widgetAt(*(const QPoint*)p);
}

QWidgetH QApplication_widgetAt2(int x, int y)
{
	return (QWidgetH) QApplication::widgetAt(x, y);
}

QWidgetH QApplication_topLevelAt(const QPointH p)
{
	return (QWidgetH) QApplication::topLevelAt(*(const QPoint*)p);
}

QWidgetH QApplication_topLevelAt2(int x, int y)
{
	return (QWidgetH) QApplication::topLevelAt(x, y);
}

void QApplication_syncX()
{
	QApplication::syncX();
}

void QApplication_beep()
{
	QApplication::beep();
}

void QApplication_alert(QWidgetH widget, int duration)
{
	QApplication::alert((QWidget*)widget, duration);
}

unsigned int QApplication_keyboardModifiers()
{
	return (unsigned int) QApplication::keyboardModifiers();
}

unsigned int QApplication_mouseButtons()
{
	return (unsigned int) QApplication::mouseButtons();
}

void QApplication_setDesktopSettingsAware(bool p1)
{
	QApplication::setDesktopSettingsAware(p1);
}

bool QApplication_desktopSettingsAware()
{
	return (bool) QApplication::desktopSettingsAware();
}

void QApplication_setCursorFlashTime(int p1)
{
	QApplication::setCursorFlashTime(p1);
}

int QApplication_cursorFlashTime()
{
	return (int) QApplication::cursorFlashTime();
}

void QApplication_setDoubleClickInterval(int p1)
{
	QApplication::setDoubleClickInterval(p1);
}

int QApplication_doubleClickInterval()
{
	return (int) QApplication::doubleClickInterval();
}

void QApplication_setKeyboardInputInterval(int p1)
{
	QApplication::setKeyboardInputInterval(p1);
}

int QApplication_keyboardInputInterval()
{
	return (int) QApplication::keyboardInputInterval();
}

void QApplication_setWheelScrollLines(int p1)
{
	QApplication::setWheelScrollLines(p1);
}

int QApplication_wheelScrollLines()
{
	return (int) QApplication::wheelScrollLines();
}

void QApplication_setGlobalStrut(const QSizeH p1)
{
	QApplication::setGlobalStrut(*(const QSize*)p1);
}

void QApplication_globalStrut(PSize retval)
{
	*(QSize *)retval = QApplication::globalStrut();
}

void QApplication_setStartDragTime(int ms)
{
	QApplication::setStartDragTime(ms);
}

int QApplication_startDragTime()
{
	return (int) QApplication::startDragTime();
}

void QApplication_setStartDragDistance(int l)
{
	QApplication::setStartDragDistance(l);
}

int QApplication_startDragDistance()
{
	return (int) QApplication::startDragDistance();
}

void QApplication_setLayoutDirection(Qt::LayoutDirection direction)
{
	QApplication::setLayoutDirection(direction);
}

Qt::LayoutDirection QApplication_layoutDirection()
{
	return (Qt::LayoutDirection) QApplication::layoutDirection();
}

bool QApplication_isRightToLeft()
{
	return (bool) QApplication::isRightToLeft();
}

bool QApplication_isLeftToRight()
{
	return (bool) QApplication::isLeftToRight();
}

bool QApplication_isEffectEnabled(Qt::UIEffect p1)
{
	return (bool) QApplication::isEffectEnabled(p1);
}

void QApplication_setEffectEnabled(Qt::UIEffect p1, bool enable)
{
	QApplication::setEffectEnabled(p1, enable);
}

#if defined BINUX
bool QApplication_x11EventFilter(QApplicationH handle, XEvent* p1)
{
	return (bool) ((QApplication *)handle)->x11EventFilter(p1);
}

int QApplication_x11ClientMessage(QApplicationH handle, QWidgetH p1, XEvent* p2, bool passive_only)
{
	return (int) ((QApplication *)handle)->x11ClientMessage((QWidget*)p1, p2, passive_only);
}

int QApplication_x11ProcessEvent(QApplicationH handle, XEvent* p1)
{
	return (int) ((QApplication *)handle)->x11ProcessEvent(p1);
}

#endif
#if defined BINUX || MSWINDOWS || DARWIN
bool QApplication_isSessionRestored(QApplicationH handle)
{
	return (bool) ((QApplication *)handle)->isSessionRestored();
}

void QApplication_sessionId(QApplicationH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QApplication *)handle)->sessionId();
	copyQStringToPWideString(t_retval, retval);
}

void QApplication_sessionKey(QApplicationH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QApplication *)handle)->sessionKey();
	copyQStringToPWideString(t_retval, retval);
}

void QApplication_commitData(QApplicationH handle, QSessionManagerH sm)
{
	((QApplication *)handle)->commitData(*(QSessionManager*)sm);
}

void QApplication_saveState(QApplicationH handle, QSessionManagerH sm)
{
	((QApplication *)handle)->saveState(*(QSessionManager*)sm);
}

#endif
void QApplication_setInputContext(QApplicationH handle, QInputContextH p1)
{
	((QApplication *)handle)->setInputContext((QInputContext*)p1);
}

QInputContextH QApplication_inputContext(QApplicationH handle)
{
	return (QInputContextH) ((QApplication *)handle)->inputContext();
}

void QApplication_keyboardInputLocale(QLocaleH retval)
{
	*(QLocale *)retval = QApplication::keyboardInputLocale();
}

Qt::LayoutDirection QApplication_keyboardInputDirection()
{
	return (Qt::LayoutDirection) QApplication::keyboardInputDirection();
}

int QApplication_exec()
{
	return (int) QApplication::exec();
}

bool QApplication_notify(QApplicationH handle, QObjectH p1, QEventH p2)
{
	return (bool) ((QApplication *)handle)->notify((QObject*)p1, (QEvent*)p2);
}

void QApplication_setQuitOnLastWindowClosed(bool quit)
{
	QApplication::setQuitOnLastWindowClosed(quit);
}

bool QApplication_quitOnLastWindowClosed()
{
	return (bool) QApplication::quitOnLastWindowClosed();
}

void QApplication_styleSheet(QApplicationH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QApplication *)handle)->styleSheet();
	copyQStringToPWideString(t_retval, retval);
}

void QApplication_setStyleSheet(QApplicationH handle, PWideString sheet)
{
	QString t_sheet;
	copyPWideStringToQString(sheet, t_sheet);
	((QApplication *)handle)->setStyleSheet(t_sheet);
}

void QApplication_closeAllWindows()
{
	QApplication::closeAllWindows();
}

void QApplication_aboutQt()
{
	QApplication::aboutQt();
}

#if defined MSWINDOWS
void QApplication_winFocus(QApplicationH handle, QWidgetH p1, bool p2)
{
	((QApplication *)handle)->winFocus((QWidget*)p1, p2);
}

void QApplication_winMouseButtonUp()
{
	QApplication::winMouseButtonUp();
}

#endif
#if defined DARWIN
bool QApplication_macEventFilter(QApplicationH handle, EventHandlerCallRef p1, EventRef p2)
{
	return (bool) ((QApplication *)handle)->macEventFilter(p1, p2);
}

#endif
#if defined QTOPIA
bool QApplication_qwsEventFilter(QApplicationH handle, QWSEventH p1)
{
	return (bool) ((QApplication *)handle)->qwsEventFilter((QWSEvent*)p1);
}

int QApplication_qwsProcessEvent(QApplicationH handle, QWSEventH p1)
{
	return (int) ((QApplication *)handle)->qwsProcessEvent((QWSEvent*)p1);
}

void QApplication_qwsSetCustomColors(QApplicationH handle, QRgb * colortable, int start, int numColors)
{
	((QApplication *)handle)->qwsSetCustomColors((QRgb*)colortable, start, numColors);
}

QDecorationH QApplication_qwsDecoration()
{
	return (QDecorationH) &QApplication::qwsDecoration();
}

void QApplication_qwsSetDecoration(QDecorationH p1)
{
	QApplication::qwsSetDecoration((QDecoration*)p1);
}

QDecorationH QApplication_qwsSetDecoration2(PWideString decoration)
{
	QString t_decoration;
	copyPWideStringToQString(decoration, t_decoration);
	return (QDecorationH) QApplication::qwsSetDecoration(t_decoration);
}

#endif
