#ifndef _MOVELOGPROB_H
#define _MOVELOGPROB_H

#include "osl/move.h"
#include <iosfwd>

namespace osl
{
  class MoveLogProb
  {
    Move move;
    int logProb;
  public:
    MoveLogProb(Move m,int l) :move(m),logProb(l)
    {
      assert(m.isInvalid() || m.isValidOrPass());
    }
    MoveLogProb() : move(), logProb(0) {}

    void setLogProb(int l)  { logProb=l; }
    /** 
     * logProb を数字上最低 l にする.
     * 確率としては，高すぎる確率の場合，l に補正する
     */
    void setLogProbAtLeast(int l)  
    { 
      if (logProb < l)
	setLogProb(l);
    }
    /** 
     * logProb を数字上最高 l にする.
     * 確率としては，低すぎる確率の場合，l に補正する
     */
    void setLogProbAtMost(int l)  
    { 
      if (logProb > l)
	setLogProb(l);
    }

    const Move getMove()const{ return move; }
    int getLogProb()const{ return logProb; }
    bool validMove() const { return logProb > 0; }
  };
  std::ostream& operator<<(std::ostream& os,MoveLogProb const& moveLogProb);

  inline bool operator==(MoveLogProb const& lhs,MoveLogProb const& rhs)
  {
    return lhs.getMove()==rhs.getMove() && lhs.getLogProb()==rhs.getLogProb();
  }
  inline bool operator<(MoveLogProb const& lhs,MoveLogProb const& rhs)
  {
    if (lhs.getMove() != rhs.getMove())
      return lhs.getMove() < rhs.getMove();
    return lhs.getLogProb() < rhs.getLogProb();
  }

} // namespace ostream


#endif /* _MOVELOGPROB_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
