(**
   Implements toolstips, known from windows.

  TODO
  * Share more code with VOWindow
**)

MODULE VO:QuickHelp;

(*
    Implements tooltips.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)


IMPORT D   := VO:Base:Display,
       E   := VO:Base:Event,
       F   := VO:Base:Frame,
       U   := VO:Base:Util,
       Z   := VO:Base:Size,

       DI  := VO:OS:Display,

       P   := VO:Prefs:Base,

       FG  := VO:FrameGroup,
       G   := VO:Object;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc* = RECORD (P.PrefsDesc)
                 frame*   : LONGINT; (* the frame to use for the button *)
                 hOffset*,
                 vOffset* : Z.SizeDesc;
               END;

  Help*         = POINTER TO HelpDesc;
  HelpDesc*     = RECORD (DI.WindowDesc)
                    prefs     : Prefs;
                    top,
                    reference : G.Object;
                    refWin    : D.Window;
                    frame     : FG.FrameGroup;
                  END;

VAR
  prefs* : Prefs;


  PROCEDURE (p : Prefs) Init*;

  BEGIN
    p.Init^;

    p.frame:=F.single;
    p.hOffset.Init;
    p.vOffset.Init;

    p.hOffset.SetSize(Z.softUnit,2);
    p.vOffset.SetSize(Z.softUnit,2);
  END Init;

  (**
    Initializes a tooltip with help as child which ooccurs
    directly beneth reference.

    You must explizitly assign the tooltip to the object you want to
    give help for. This is not done automatically by this function.
  **)

  PROCEDURE InitHelp*(help,reference : G.Object):Help;

  VAR
    h : Help;

  BEGIN
    NEW(h);
    h.Init;

    h.Grab(TRUE);
    h.Borderless(TRUE);

    h.prefs:=prefs;

    h.top:=help;
    h.reference:=reference;
    h.frame:=NIL;

    RETURN h;
  END InitHelp;

  PROCEDURE (h : Help) CalcSize;

  BEGIN
    h.frame:=FG.CreateFrameGroup();
    h.frame.SetBackground(D.helpBackgroundColor);
    h.frame.SetFrame(h.prefs.frame);
    h.frame.SetFlags({G.horizontalFlex,G.verticalFlex});
    h.frame.SetSpace(TRUE);
    h.frame.SetObject(h.top);
    h.frame.SetWindow(h);

    h.frame.CalcSize;
    h.SetSize(h.frame.width,h.frame.height);
  END CalcSize;

  PROCEDURE (h : Help) CursorIsIn():BOOLEAN;

  VAR
    rx,ry,
    wx,wy  : LONGINT;

  BEGIN
    h.GetMousePos(rx,ry,wx,wy);
    IF (wx>=0) & (wx<=h.width-1) & (wy>=0) & (wy<=h.height-1) THEN
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END CursorIsIn;

  PROCEDURE (h : Help) PreInit*;

  VAR
    rx,ry,
    wx,wy,
    x,y    : LONGINT;

  BEGIN
    h.CalcSize;

    h.refWin:=h.reference.GetWindow();

    h.refWin.GetMousePos(rx,ry,wx,wy);
    x:=rx+h.prefs.hOffset.GetSize();
    y:=ry+h.prefs.vOffset.GetSize();

    x:=U.RoundRange(x,0,D.display.scrWidth-1-h.width);
    y:=U.RoundRange(y,0,D.display.scrHeight-1-h.height);

    h.SetPos(x,y);
    h.SetPosition(D.manualPos,D.manualPos);

    h.SetBackground(D.helpBackgroundColor);

    h.PreInit^;
  END PreInit;

  PROCEDURE (h : Help) Draw*;

  BEGIN
    h.frame.Move(0,0);
    h.frame.Draw(0,0,h.width,h.height);
  END Draw;

  (**
    Redraw the given area of the window.
  **)

  PROCEDURE (h : Help) Redraw*(x,y,width,height : LONGINT);

  BEGIN
    h.frame.Draw(x,y,width,height);
  END Redraw;

  PROCEDURE (h : Help) Left*;

  BEGIN
    h.Close;
  END Left;

  PROCEDURE (h : Help) Hidden*;

  BEGIN
    h.Close;
  END Hidden;

  PROCEDURE (h : Help) HandleEvent*(event : E.Event):BOOLEAN;

  BEGIN
    IF h.HandleEvent^(event) THEN
      RETURN TRUE;
    END;

    WITH
      event : E.ButtonEvent DO
        h.Close;
        D.display.PutBackEvent(event,h.refWin);
    | event : E.MotionEvent DO
        h.Close;
    | event : E.KeyEvent DO
        h.Close;
        D.display.PutBackEvent(event,h.refWin);
    ELSE
    END;
    RETURN TRUE;
  END HandleEvent;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:QuickHelp.