(**
**)

MODULE VO:Model:Header;

(*
    A model for describing columns or rows.
    Copyright (C) 2000  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT O   := VO:Base:Object,
       U   := VO:Base:Util;

TYPE
  HeaderModel*       = POINTER TO HeaderModelDesc;
  HeaderModelDesc*   = RECORD (O.ModelDesc)
                       END;

  EntryDesc          = RECORD
                         text : U.Text;
                         size : LONGINT;
                       END;

  Entries            = POINTER TO ARRAY OF EntryDesc;

  AHeaderModel*      = POINTER TO AHeaderModelDesc;
  AHeaderModelDesc*  = RECORD (HeaderModelDesc)
                         entries : Entries;
                       END;

  PROCEDURE (h : HeaderModel) Init*;

  BEGIN
    h.Init^;
  END Init;

  PROCEDURE (h : HeaderModel) GetEntries*():LONGINT;

  BEGIN
    RETURN 0;
  END GetEntries;

  PROCEDURE (h : HeaderModel) SetEntrySize*(index,size : LONGINT);

  BEGIN
  END SetEntrySize;

  PROCEDURE (h : HeaderModel) GetEntrySize*(index : LONGINT):LONGINT;

  BEGIN
    RETURN 15;
  END GetEntrySize;

  PROCEDURE (h : HeaderModel) GetEntryText*(x : LONGINT):U.Text;

  BEGIN
    RETURN NIL;
  END GetEntryText;



  PROCEDURE (h : AHeaderModel) Init*;

  BEGIN
    h.Init^;

    h.entries:=NIL;
  END Init;

  PROCEDURE (h : AHeaderModel) GetEntries*():LONGINT;

  BEGIN
    IF h.entries=NIL THEN
      RETURN 0;
    ELSE
      RETURN LEN(h.entries^);
    END;
  END GetEntries;

  PROCEDURE (h : AHeaderModel) GetEntrySize*(index : LONGINT):LONGINT;

  BEGIN
    IF (h.entries=NIL) OR (index>=LEN(h.entries^)) THEN
      RETURN 0;
    ELSE
      RETURN h.entries[index].size;
    END;
  END GetEntrySize;

  PROCEDURE (h : AHeaderModel) GetEntryText*(index : LONGINT):U.Text;

  BEGIN
    IF (h.entries=NIL) OR (index>=LEN(h.entries^)) THEN
      RETURN NIL;
    ELSE
       RETURN h.entries[index].text;
     END;
  END GetEntryText;

  PROCEDURE (h : AHeaderModel) CreateEntries(size : LONGINT);

  VAR
    old : Entries;
    x   : LONGINT;

  BEGIN
    IF (h.entries=NIL) OR (size>LEN(h.entries^)) THEN
      old:=h.entries;

      NEW(h.entries,size);
      x:=0;
      IF old#NIL THEN
        WHILE x<LEN(old^) DO
          h.entries[x]:=old[x];
          INC(x);
        END;
      END;

      WHILE x<LEN(h.entries^) DO
        h.entries[x].size:=0;
        h.entries[x].text:=NIL;
        INC(x);
      END;
    END;
  END CreateEntries;

  PROCEDURE (h : AHeaderModel) SetEntryText*(index : LONGINT; text : U.Text);

  BEGIN
    h.CreateEntries(index+1);
    h.entries[index].text:=text;
  END SetEntryText;

  PROCEDURE (h : AHeaderModel) SetEntryString*(index : LONGINT; text : ARRAY OF CHAR);

  BEGIN
    h.CreateEntries(index+1);
    h.entries[index].text:=U.EscapeString(text);
  END SetEntryString;

  PROCEDURE (h : AHeaderModel) SetEntrySize*(index,size : LONGINT);

  BEGIN
    h.CreateEntries(index+1);
    h.entries[index].size:=size;
  END SetEntrySize;

END VO:Model:Header.