MODULE VO:EditFile;

IMPORT B   := VO:EditBlock,
       R   := VO:EditRun,
       T   := VO:EditText,

              Ascii,
       b   := BinaryRider,
       f   := Files;


  (**
    Reads the given file into the text.
  **)

  PROCEDURE LoadFromBuffer*(text : T.Buffer; buffer : ARRAY OF CHAR; size : LONGINT);


  VAR
    x,blocks,
    bufPos     : LONGINT;
    pos,look   : LONGINT;
    last       : R.Run;
    run        : R.TextRun;
    line       : R.LineRun;

  BEGIN
    text.New;

    blocks:=size DIV B.blockLen;
    IF size MOD B.blockLen#0 THEN
      INC(blocks);
    END;

    IF blocks#0 THEN

      bufPos:=0;
      x:=1;
      last:=text.first;

      WHILE x<=blocks DO

        B.GetBlockWithSize(B.blockLen);

        IF x<blocks THEN
          B.block.size:=LEN(B.block.text);
        ELSE
          B.block.size:=size MOD LEN(B.block.text);
        END;

        FOR look:=0 TO B.block.size-1 DO
          B.block.text[look]:=buffer[bufPos];
        END;

        pos:=0;
        FOR look:=0 TO B.block.size-1 DO
          IF B.block.text[look]=Ascii.lf THEN
            NEW(run);
            run.Init;
            run.block:=B.block;
            run.pos:=pos;
            run.length:=look-pos;
            last.InsertAfter(run);

            last:=run;
            pos:=look+1;

            IF ~((x=blocks) & (look=B.block.size-1)) THEN
              NEW(line);
              line.Init;
              last.InsertAfter(line);
              last:=line;
              INC(text.lines);
            END;
          END;
        END;

        IF pos<=B.block.size-1 THEN
          NEW(run);
          run.Init;
          run.block:=B.block;
          run.pos:=pos;
          run.length:=look-pos;
          last.InsertAfter(run);
          last:=run;
        END;

        INC(x);
      END;
    END;
  END LoadFromBuffer;


  (**
    Reads the given file into the text.
  **)

  PROCEDURE LoadFromFile*(text : T.Buffer; name : ARRAY OF CHAR):f.Result;


  VAR
    reader        : b.Reader;
    res           : f.Result;
    file          : f.File;

    size          : LONGINT;

    x,blocks      : LONGINT;
    error         : BOOLEAN;
    pos,look      : LONGINT;
    last          : R.Run;
    run           : R.TextRun;
    line          : R.LineRun;

  BEGIN
    file:=f.Old(name,{f.read},res);
    IF file#NIL THEN
      reader:=b.ConnectReader(file);
      IF reader#NIL THEN

        text.New;

        size:=reader.Available();
        blocks:=size DIV B.blockLen;
        IF size MOD B.blockLen#0 THEN
          INC(blocks);
        END;

        IF blocks#0 THEN

          error:=FALSE;
          x:=1;
          last:=text.first;

          WHILE ~error & (x<=blocks) DO

            B.GetBlockWithSize(B.blockLen);

            IF x<blocks THEN
              B.block.size:=LEN(B.block.text);
            ELSE
              B.block.size:=size MOD LEN(B.block.text);
            END;

            reader.ReadBytes(B.block.text,0,B.block.size);

            IF reader.res=b.done THEN

              pos:=0;
              FOR look:=0 TO B.block.size-1 DO
                IF B.block.text[look]=Ascii.lf THEN
                  NEW(run);
                  run.Init;
                  run.block:=B.block;
                  run.pos:=pos;
                  run.length:=look-pos;
                  last.InsertAfter(run);

                  last:=run;
                  pos:=look+1;

                  IF ~((x=blocks) & (look=B.block.size-1)) THEN
                    NEW(line);
                    line.Init;
                    last.InsertAfter(line);
                    last:=line;
                    INC(text.lines);
                  END;
                END;
              END;

              IF pos<=B.block.size-1 THEN
                NEW(run);
                run.Init;
                run.block:=B.block;
                run.pos:=pos;
                run.length:=look-pos;
                last.InsertAfter(run);
                last:=run;
              END;

            ELSE
              error:=TRUE;
            END;

            INC(x);
          END;
        END;
      END;
      file.Close;
    END;

    RETURN res;
  END LoadFromFile;

(* ------------------------------------------------------------------------ *)

  (**
    Save the text in the given text to a file.
  **)

  PROCEDURE SaveToFile*(text : T.Buffer; name : ARRAY OF CHAR):f.Result;

  VAR
    file   : f.File;
    writer : b.Writer;
    res    : f.Result;

    start  : R.Run;

  BEGIN
    file:=f.New(name,{f.write},res);
    IF file#NIL THEN
      writer:=b.ConnectWriter(file);
      IF writer#NIL THEN

        start:=text.first.next; (* We do not save the starting newline *)

        WHILE start#NIL DO

          WITH
            start : R.TextRun DO
              writer.WriteBytes(start.block.text,start.pos,start.length);
          | start : R.LineRun DO
              writer.WriteChar(Ascii.lf);
          ELSE
          END;

          start:=start.next;
        END;

(*        writer.WriteChar(Ascii.lf);*)
      END;
      res:=writer.res;

      file.Close;
    END;

    RETURN res;
  END SaveToFile;

(* ------------------------------------------------------------------------ *)

  PROCEDURE ErrorToString*(res : f.Result; VAR string : ARRAY OF CHAR);

  BEGIN
    IF res=f.done THEN
      COPY("",string);
    ELSE
      res.GetText(string);
    END;
  END ErrorToString;

END VO:EditFile.