(**
   A number of utility functions.
**)

MODULE VO:Base:Util;

(*
    Utility functions for VisualOberon.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT      C,
            Ascii,
            LongStrings,
            Strings;

TYPE
  Text* = POINTER TO ARRAY OF CHAR;
  LongText* = POINTER TO ARRAY OF LONGCHAR;

  (* Some tool-functions *)

  (**
     Returns the maximum of the two numbers given.
  **)

  PROCEDURE MaxLong*(a,b : LONGINT):LONGINT;

  BEGIN
    IF a>=b THEN
      RETURN a;
    ELSE
      RETURN b;
    END;
  END MaxLong;

  (**
     Returns the minumum of the two numbers given.
  **)

  PROCEDURE MinLong*(a,b : LONGINT):LONGINT;

  BEGIN
    IF a<=b THEN
      RETURN a;
    ELSE
      RETURN b;
    END;
  END MinLong;

  (**
     Modifies @var{x} so that i is in the range
     between @var{a} and @var{b} including.
  **)

  PROCEDURE RoundRange*(x,a,b : LONGINT):LONGINT;

  BEGIN
    IF x<a THEN
      RETURN a;
    ELSIF x>b THEN
      RETURN b;
    ELSE
      RETURN x;
    END;
  END RoundRange;

  (**
     Returns a newly allocated array pointing to the given string, where
     all escape sequences has been converted. Currently supported are:
     @code{\n}, @code{\e} and @code{\t}.
  **)

  PROCEDURE EscapeString*(string : ARRAY OF CHAR):Text;

  VAR
    len,a,b : LONGINT;
    copy    : Text;

  BEGIN
    len:=Strings.Length(string);

    b:=len+1;
    a:=0;
    WHILE a<=len-1 DO
      IF string[a]="\" THEN
        DEC(b);
        INC(a);
      END;
      INC(a);
    END;
    NEW(copy,b);

    a:=0;
    b:=0;
    WHILE a<len DO
      CASE string[a] OF
        "\" : INC(a);
              IF a<len THEN
                CASE string[a] OF
                  "e" : copy[b]:=Ascii.esc;
                | "n" : copy[b]:=Ascii.lf;
                | "t" : copy[b]:=Ascii.ht;
                ELSE
                  copy[b]:=string[a];
                END;
                INC(a);
                INC(b);
              ELSE
                RETURN NIL;
              END;
      ELSE
        copy[b]:=string[a];
        INC(a);
        INC(b);
      END;
    END;

    copy[b]:=0X;

    RETURN copy;
  END EscapeString;

  PROCEDURE EscapeLongString*(string : ARRAY OF LONGCHAR):LongText;

  VAR
    len,a,b : LONGINT;
    copy    : LongText;

  BEGIN
    len:=LongStrings.Length(string);

    b:=len+1;
    a:=0;
    WHILE a<=len-1 DO
      IF string[a]="\" THEN
        DEC(b);
        INC(a);
      END;
      INC(a);
    END;
    NEW(copy,b);

    a:=0;
    b:=0;
    WHILE a<len DO
      CASE string[a] OF
        "\" : INC(a);
              IF a<len THEN
                CASE string[a] OF
                  "e" : copy[b]:=Ascii.esc;
                | "n" : copy[b]:=Ascii.lf;
                | "t" : copy[b]:=Ascii.ht;
                ELSE
                  copy[b]:=string[a];
                END;
                INC(a);
                INC(b);
              ELSE
                RETURN NIL;
              END;
      ELSE
        copy[b]:=string[a];
        INC(a);
        INC(b);
      END;
    END;

    copy[b]:=0X;

    RETURN copy;
  END EscapeLongString;

  (**

  **)

  PROCEDURE UpDiv*(a,b : LONGINT):LONGINT;

  BEGIN
    IF a DIV b=0 THEN
      IF a<0 THEN
        RETURN -1;
      ELSIF a>0 THEN
        RETURN 1;
      ELSE
        RETURN 0;
      END;
    ELSE
      RETURN a DIV b;
    END;
  END UpDiv;

  (**
     Rounds to the nearest integer number.
  **)

  PROCEDURE RoundDiv*(a,b :LONGINT):LONGINT;

  VAR
    c : LONGINT;

  BEGIN
    c:=a DIV b;
    IF a MOD b>=b DIV 2 THEN
      INC(c);
    END;
    RETURN c;
  END RoundDiv;

  (**
    Rounds the number so that is is even. Currently only works correctly for
    numbers greater zero.
  **)

  PROCEDURE RoundUpEven*(a : LONGINT):LONGINT;

  BEGIN
    IF a DIV 2>0 THEN
      RETURN a+1;
    ELSE
      RETURN a;
    END;
  END RoundUpEven;

  PROCEDURE CStringToText*(string : C.charPtr1d):Text;

  VAR
    length : LONGINT;
    text   : Text;

  BEGIN
    IF string=NIL THEN
      NEW(text,1);
      text[0]:=0X;
    ELSE
      length:=0;
      WHILE string[length]#0X DO
        INC(length);
      END;
      INC(length);
      NEW(text,length);
      DEC(length);
      WHILE length>=0 DO
        text[length]:=string[length];
        DEC(length);
      END;
    END;
    RETURN text;
  END CStringToText;

  PROCEDURE CStringToLongText*(string : C.charPtr1d):LongText;

  VAR
    length : LONGINT;
    text   : LongText;

  BEGIN
    IF string=NIL THEN
      NEW(text,1);
      text[0]:=0X;
    ELSE
      length:=0;
      WHILE string[length]#0X DO
        INC(length);
      END;
      INC(length);
      NEW(text,length);
      DEC(length);
      WHILE length>=0 DO
        text[length]:=string[length];
        DEC(length);
      END;
    END;
    RETURN text;
  END CStringToLongText;

END VO:Base:Util.