/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.soap;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;

import mx4j.tools.remote.AbstractJMXConnectorServer;
import mx4j.tools.remote.ConnectionManager;
import mx4j.tools.remote.http.HTTPConnectionManager;
import mx4j.tools.remote.http.HTTPConnectorServer;

/**
 * @version $Revision: 1.17 $
 */
public class SOAPConnectorServer extends HTTPConnectorServer
{
   public SOAPConnectorServer(JMXServiceURL url, Map environment, MBeanServer server)
   {
      super(url, environment, server);
   }

   protected ConnectionManager createConnectionManager(AbstractJMXConnectorServer server, Map environment)
   {
      return new HTTPConnectionManager(server, "soap", environment);
   }
}
