#include <mb128misc.h>

void
mb_misc_convg0sl(mb_char_t *ch, mb_info_t *info)
{
  return;
}

#define MB_MISC_SUBFC_MAX (((1 << (10 - 7)) * 3) - 1)
#define MB_MISC_ENC(c, subfc) (((c) & ((1 << 7) - 1)) | ((subfc) << 7))

int
mb_misc_enc(int c, mb_info_t *info)
{
  mb_char_t ch;

  if ((info->GR >> MB_ESC_LEN) >= 0 && (info->GR >> MB_ESC_LEN) <= MB_MISC_SUBFC_MAX) {
    ch.c = MB_MISC_ENC(c, info->GR >> MB_ESC_LEN);
    ch.fc = MB_MISC_FC;
  }
  else {
    ch.c = c;
    ch.fc = MB_UNKNOWN_FC;
  }

  ch.set = mb_128;
  ch.gn = mb_G1;
  ch.sn = mb_SR;
  return mb_utf8_badenc(&ch, info);
}

size_t
mb_misc_dec(int c, int fc, char *buf)
{
  buf[0] = (c & ((1 << 7) - 1)) | (1 << 7);
  return 1;
}

size_t
mb_misc_width(mb_char_t *ch)
{
  return 1;
}

#ifdef USE_UCS
void
mb_conv_ucs_to_misc(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_128, MB_MISC_FC):
	  if ((MB_WORD_DEC_C(*p) >> 7) == (info->GR >> MB_ESC_LEN)) {
	    ch->c = MB_WORD_DEC_C(*p);
	    ch->set = mb_128;
	    ch->fc = (MB_MISC_FC & MB_ESC_FC_MASK);
	    ch->gn = mb_G1;
	    ch->sn = mb_SR;
	  }
	  return;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p))
	  return;
      }
    }
  }
}

void
mb_conv_ms_latin1(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128)
    switch (ch->fc & MB_ESC_FC_MASK) {
    case MB_UNKNOWN_FC & MB_ESC_FC_MASK:
    case 0x47 & MB_ESC_FC_MASK:
      if (ch->c >= 0x80 && ch->c <= 0x9F) {
	ch->c = MB_MISC_ENC(ch->c, mb128misc_WIN1252);
	ch->fc = MB_MISC_FC & MB_ESC_FC_MASK;
	mb_conv_iso_to_ucs(ch, info);
      }
    default:
      break;
    }
}
#endif
