#ifndef ISO2MB_KR_H

#define ISO2MB_KR_H

#include <mb.h>

#define MB_JOHABLL_FC (mb_JOHAB_FCs & ((1 << 7) - 1))
#define MB_JOHABLR_FC (MB_JOHABLL_FC + 1)
#define MB_JOHABH_FC ((mb_JOHAB_FCs >> 7) & ((1 << 7) - 1))

#define MB_JOHABH_HI (0xF9 - 0xE0 + 1 + 0xDE - 0xD8 + 1)

#define MB_UHANGLL_FC (mb_UHANG_FCs & ((1 << 7) - 1))
#define MB_UHANGLR_FC (MB_UHANGLL_FC + 1)
#define MB_UHANGH_FC ((mb_UHANG_FCs >> 7) & ((1 << 7) - 1))

enum {
  mb_cs_detect_kr_EUC,
  mb_cs_detect_kr_JOHAB,
  mb_cs_detect_kr_UTF8,
  mb_cs_detect_kr_UHANG,
  mb_cs_detect_kr_N,
};

extern void mb_conv_iso2022kr(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_euc_kr(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_uhang(mb_char_t *ch, mb_info_t *info);
extern void mb_cs_judge_euc_kr(mb_cs_detector_stat_t *p, const char *bag, size_t e);
extern void mb_cs_judge_johab(mb_cs_detector_stat_t *p, const char *bag, size_t e);
extern void mb_cs_judge_uhang(mb_cs_detector_stat_t *p, const char *bag, size_t e);
extern size_t mb_cs_judge_kr(mb_cs_detector_t *p);
extern char *mb_cs_setup_kr(mb_cs_detector_t *p, size_t i, size_t same);

#ifdef USE_UCS

#include <ucs.h>

extern void mb_conv_ucs_to_kr(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_ucs_to_johab(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_ucs_to_uhang(mb_char_t *ch, mb_info_t *info);

#endif

#endif
