#include "kr.h"

void
mb_johab_convg0sl(mb_char_t *ch, mb_info_t *info)
{
  return;
}

int
mb_johab_enc(int c, mb_info_t *info)
{
  int cc;
  mb_char_t ch;

  if (c >= 0x84 && c <= 0xD3) {
    if ((cc = mb_call_getc(info)) == EOF)
      goto badgr;
    else if (cc >= 0x41 && cc <= 0x7E) {
      ch.c = (c - 0x84) * 0x60 + cc - 0x41;
      ch.fc = MB_JOHABLL_FC;
    }
    else if (cc >= 0x81 && cc <= 0xA0) {
      ch.c = (c - 0x84) * 0x60 + cc - 0x81 + 0x7F - 0x41;
      ch.fc = MB_JOHABLL_FC;
    }
    else if (cc >= 0xA1 && cc <= 0xFE) {
      ch.c = (c - 0x84) * 0x60 + cc - 0xA0;
      ch.fc = MB_JOHABLR_FC;
    }
    else
      goto badgr1;
  }
  else if (c >= 0xD8 && c <= 0xDE) {
    if ((cc = mb_call_getc(info)) == EOF)
      goto badgr;
    else if (cc >= 0x31 && cc <= 0x7E) {
      ch.c = (c - 0xD7) * 0x60 + cc - 0x30;
      ch.fc = MB_JOHABH_FC;
    }
    else if (cc >= 0x91 && cc <= 0xA0) {
      ch.c = (c - 0xD7) * 0x60 + cc - 0x91 + 0x7F - 0x30;
      ch.fc = MB_JOHABH_FC;
    }
    else if (cc >= 0xA1 && cc <= 0xFE) {
      ch.c = (c - 0xD7 + MB_JOHABH_HI) * 0x60 + cc - 0xA0;
      ch.fc = MB_JOHABH_FC;
    }
    else
      goto badgr1;
  }
  else if (c >= 0xE0 && c <= 0xF9) {
    if ((cc = mb_call_getc(info)) == EOF)
      goto badgr;
    else if (cc >= 0x31 && cc <= 0x7E) {
      ch.c = (c - 0xE0 + 0xDF - 0xD7) * 0x60 + cc - 0x30;
      ch.fc = MB_JOHABH_FC;
    }
    else if (cc >= 0x91 && cc <= 0xA0) {
      ch.c = (c - 0xE0 + 0xDF - 0xD7) * 0x60 + cc - 0x91 + 0x7F - 0x30;
      ch.fc = MB_JOHABH_FC;
    }
    else if (cc >= 0xA1 && cc <= 0xFE) {
      ch.c = (c - 0xE0 + 0xDF - 0xD7 + MB_JOHABH_HI) * 0x60 + cc - 0xA0;
      ch.fc = MB_JOHABH_FC;
    }
    else
      goto badgr1;
  }
  else
    goto badgr;

  goto end;
badgr1: {
    char temp[1];

    temp[0] = cc;
    mb_fill_inbuf(info, temp, 1);
  }
badgr:
  ch.c = c;
  ch.fc = MB_UNKNOWN_FC;
end:
  ch.set = mb_128;
  ch.gn = mb_G1;
  ch.sn = mb_SR;
  return mb_utf8_badenc(&ch, info);
}

size_t
mb_johab_dec(int c, int fc, char *buf)
{
  size_t e;
  int c1 = c / 0x60;
  int c2 = c % 0x60;

  switch (fc) {
  case MB_JOHABLL_FC & MB_ESC_FC_MASK:
    buf[0] = c1 + 0x84;

    if ((unsigned char)(buf[1] = c2 + 0x41) >= 0x7F)
      buf[1] += -0x7F + 0x81;

    e = 2;
    break;
  case MB_JOHABLR_FC & MB_ESC_FC_MASK:
    buf[0] = c1 + 0x84;
    buf[1] = c2 + 0xA0;
    e = 2;
    break;
  case MB_JOHABH_FC & MB_ESC_FC_MASK:
    if (c1 > MB_JOHABH_HI) {
      if ((unsigned char)(buf[0] = c1 - MB_JOHABH_HI + 0xD7) >= 0xDF)
	buf[0] += -0xDF + 0xE0;

      buf[1] = c2 + 0xA0;
    }
    else {
      if ((unsigned char)(buf[0] = c1 + 0xD7) >= 0xDF)
	buf[0] += -0xDF + 0xE0;

      if ((unsigned char)(buf[1] = c2 + 0x30) >= 0x7F)
	buf[1] += -0x7F + 0x91;
    }

    e = 2;
    break;
  default:
    e = 0;
    break;
  }

  return e;
}

size_t
mb_johab_width(mb_char_t *ch)
{
  return 2;
}

void
mb_uhang_convg0sl(mb_char_t *ch, mb_info_t *info)
{
  if ((ch->fc & MB_ESC_FC_MASK) == (MB_UHANGH_FC & MB_ESC_FC_MASK)) {
    ch->set = mb_94x94;
    ch->fc = 0x43 & MB_ESC_FC_MASK;
    ch->gn = mb_G0;
    ch->sn = mb_SL;
  }
}

int
mb_uhang_enc(int c, mb_info_t *info)
{
  int cc;
  mb_char_t ch;

  if (c >= 0x81 && c <= 0xA0) {
    if ((cc = mb_call_getc(info)) == EOF)
      goto badgr;
    else if ((cc >= 0x41 && cc <= 0x5A) || (cc >= 0x61 && cc <= 0x7A)) {
      ch.c = (c - 0x80) * 0x60 + cc - 0x40;
      ch.fc = MB_UHANGLL_FC;
    }
    else if (cc >= 0x81 && cc <= 0xA0) {
      ch.c = (c - 0x80) * 0x60 + cc - 0x81 + 0x7B - 0x40;
      ch.fc = MB_UHANGLL_FC;
    }
    else if (cc >= 0xA1 && cc <= 0xFE) {
      ch.c = (c - 0x81 + 0xA1 - 0x80) * 0x60 + cc - 0xA0;
      ch.fc = MB_UHANGLL_FC;
    }
    else
      goto badgr1;
  }
  else if (c >= 0xA1 && c <= 0xC6) {
    if ((cc = mb_call_getc(info)) == EOF)
      goto badgr;
    else if ((cc >= 0x41 && cc <= 0x5A) || (cc >= 0x61 && cc <= 0x7A)) {
      ch.c = (c - 0xA0) * 0x60 + cc - 0x40;
      ch.fc = MB_UHANGLR_FC;
    }
    else if (cc >= 0x81 && cc <= 0xA0) {
      ch.c = (c - 0xA0) * 0x60 + cc - 0x81 + 0x7B - 0x40;
      ch.fc = MB_UHANGLR_FC;
    }
    else if (cc >= 0xA1 && cc <= 0xFE) {
      ch.c = (c - 0xA0) * 0x60 + cc - 0xA0;
      ch.fc = MB_UHANGH_FC;
    }
    else
      goto badgr1;
  }
  else if (c >= 0xC7 && c <= 0xFE) {
    if ((cc = mb_call_getc(info)) == EOF)
      goto badgr;
    else if (cc >= 0xA1 && cc <= 0xFE) {
      ch.c = (c - 0xA0) * 0x60 + cc - 0xA0;
      ch.fc = MB_UHANGH_FC;
    }
    else
      goto badgr1;
  }
  else
    goto badgr;

  goto end;
badgr1: {
    char temp[1];

    temp[0] = cc;
    mb_fill_inbuf(info, temp, 1);
  }
badgr:
  ch.c = c;
  ch.fc = MB_UNKNOWN_FC;
end:
  ch.set = mb_128;
  ch.gn = mb_G1;
  ch.sn = mb_SR;
  return mb_utf8_badenc(&ch, info);
}

size_t
mb_uhang_dec(int c, int fc, char *buf)
{
  size_t e;
  int c1 = c / 0x60;
  int c2 = c % 0x60;

  switch (fc) {
  case MB_UHANGLL_FC & MB_ESC_FC_MASK:
    if ((c1 += 0x80) <= 0xA0) {
      buf[0] = c1;

      if ((c2 += 0x40) <= 0x7A)
	buf[1] = c2;
      else
	buf[1] = c2 - 0x7B + 0x81;
    }
    else {
      buf[0] = c1 - 0xA1 + 0x81;
      buf[1] = c2 + 0xA0;
    }
    e = 2;
    break;
  case MB_UHANGLR_FC & MB_ESC_FC_MASK:
    buf[0] = c1 + 0xA0;

    if ((c2 += 0x40) <= 0x7A)
      buf[1] = c2;
    else
      buf[1] = c2 - 0x7B + 0x81;

    e = 2;
    break;
  case MB_UHANGH_FC & MB_ESC_FC_MASK:
    buf[0] = c1 + 0xA0;
    buf[1] = c2 + 0xA0;
    e = 2;
    break;
  default:
    e = 0;
    break;
  }

  return e;
}

size_t
mb_uhang_width(mb_char_t *ch)
{
  return 2;
}

void
mb_conv_iso2022kr(mb_char_t *ch, mb_info_t *info)
{
  mb_conv_allg0sl(ch, info);

  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x43 & MB_ESC_FC_MASK:
      ch->gn = mb_G1;
      ch->sn = mb_SL;
    default:
      break;
    }
  default:
    break;
  }
}

void
mb_conv_euc_kr(mb_char_t *ch, mb_info_t *info)
{
  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x43 & MB_ESC_FC_MASK:
      ch->gn = mb_G1;
      ch->sn = mb_SR;
    default:
      break;
    }

    break;
  case mb_94_0:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x42 & MB_ESC_FC_MASK:
      ch->gn = mb_G0;
      ch->sn = mb_SL;
      break;
    }
  default:
    break;
  }
}

void
mb_conv_uhang(mb_char_t *ch, mb_info_t *info)
{
  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x43 & MB_ESC_FC_MASK:
      ch->set = mb_128;
      ch->fc = MB_UHANGH_FC;
      ch->gn = mb_G1;
      ch->sn = mb_SR;
    default:
      break;
    }
  default:
    break;
  }
}

void
mb_cs_judge_euc_kr(mb_cs_detector_stat_t *p, const char *bag, size_t e)
{
  size_t i;
  int c, cc;

  for (i = p->processed ; i < e ;)
    if ((c = (unsigned char)bag[i++]) & 0x80) {
      if (c >= 0xA1 && c <= 0xFE) {
	if (i < e) {
	  if ((cc = (unsigned char)bag[i]) >= 0xA1 && cc <= 0xFE) {
	    switch (c * 0x100 + cc) {
	    case 0xB4D9:
	    case 0xC0CC:
	      p->by_char += 2;
	    case 0xB4C2:
	    case 0xC7CF:
	      p->by_char += 2;
	    case 0xB0A1:
	    case 0xB0ED:
	    case 0xB1E2:
	    case 0xB5A5:
	    case 0xB7CE:
	    case 0xB8A6:
	    case 0xB8AE:
	    case 0xBAF1:
	    case 0xBBE7:
	    case 0xBCAD:
	    case 0xBDBA:
	    case 0xBEC8:
	    case 0xBEEE:
	    case 0xBFA1:
	    case 0xC0BA:
	    case 0xC0BB:
	    case 0xC0C7:
	    case 0xC0D6:
	    case 0xC0DA:
	    case 0xC1F6:
	    case 0xC6AE:
	    case 0xC7D1:
	      p->by_char += 2;
	    default:
	      break;
	    }

	    p->by_char += 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  break;
	}
      }
      else
	p->by_encode -= 1;
    }

  p->processed = i;
}

void
mb_cs_judge_johab(mb_cs_detector_stat_t *p, const char *bag, size_t e)
{
  size_t i;
  int c, cc;

  for (i = p->processed ; i < e ;)
    if ((c = (unsigned char)bag[i++]) & 0x80) {
      if (c >= 0x84 && c <= 0xD3) {
	if (i < e) {
	  if (((cc = (unsigned char)bag[i]) >= 0x41 && cc <= 0x7E) ||
	      (cc >= 0x81 && cc <= 0xFE)) {
	    switch (c * 0x100 + cc) {
	    case 0x9461:
	    case 0xB7A1:
	      p->by_char += 2;
	    case 0x9365:
	    case 0xD061:
	      p->by_char += 2;
	    case 0x8861:
	    case 0x89A1:
	    case 0x8BA1:
	    case 0x9541:
	    case 0x9DA1:
	    case 0x9F69:
	    case 0x9FA1:
	    case 0xA7A1:
	    case 0xAC61:
	    case 0xACE1:
	    case 0xAF61:
	    case 0xB465:
	    case 0xB4E1:
	    case 0xB541:
	    case 0xB765:
	    case 0xB769:
	    case 0xB781:
	    case 0xB7B6:
	    case 0xB861:
	    case 0xBBA1:
	    case 0xCB61:
	    case 0xD065:
	      p->by_char += 2;
	    default:
	      break;
	    }

	    p->by_char += 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  break;
	}
      }
      else if ((c >= 0xD8 && c <= 0xDE) || (c >= 0xE0 && c <= 0xF9)) {
	if (i < e) {
	  if (((cc = (unsigned char)bag[i] >= 0x31) && cc <= 0x7E) ||
	      (cc >= 0x91 && cc <= 0xFE)) {
	    p->by_char += cc <= 0x7E ? 1 : 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  break;
	}
      }
      else
	p->by_encode -= 1;
    }

  p->processed = i;
}

void
mb_cs_judge_uhang(mb_cs_detector_stat_t *p, const char *bag, size_t e)
{
  size_t i;
  int c, cc;

  for (i = p->processed ; i < e ;)
    if ((c = (unsigned char)bag[i++]) & 0x80) {
      if (c >= 0x81 && c <= 0xA0) {
	if (i < e) {
	  if (((cc = (unsigned char)bag[i]) >= 0x41 && cc <= 0x5A) ||
	      (cc >= 0x61 && cc <= 0x7A) ||
	      (cc >= 0x81 && cc <= 0xFE)) {
	    p->by_char += 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  break;
	}
      }
      else if (c >= 0xA1 && c <= 0xC6) {
	if (i < e) {
	  if (((cc = (unsigned char)bag[i]) >= 0x41 && cc <= 0x5A) ||
	      (cc >= 0x61 && cc <= 0x7A) ||
	      (cc >= 0x81 && cc <= 0xA0)) {
	    p->by_char += 2;
	    ++i;
	  }
	  else if (cc >= 0xA1 && cc <= 0xFE) {
	    switch (c * 0x100 + cc) {
	    case 0xB4D9:
	    case 0xC0CC:
	      p->by_char += 2;
	    case 0xB4C2:
	      p->by_char += 2;
	    case 0xB0A1:
	    case 0xB0ED:
	    case 0xB1E2:
	    case 0xB5A5:
	    case 0xB7CE:
	    case 0xB8A6:
	    case 0xB8AE:
	    case 0xBAF1:
	    case 0xBBE7:
	    case 0xBCAD:
	    case 0xBDBA:
	    case 0xBEC8:
	    case 0xBEEE:
	    case 0xBFA1:
	    case 0xC0BA:
	    case 0xC0BB:
	    case 0xC0C7:
	    case 0xC0D6:
	    case 0xC0DA:
	    case 0xC1F6:
	    case 0xC6AE:
	      p->by_char += 2;
	    default:
	      break;
	    }

	    p->by_char += 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  break;
	}
      }
      else if (c >= 0xA1 && c <= 0xFE) {
	if (i < e) {
	  if ((cc = (unsigned char)bag[i]) >= 0xA1 && cc <= 0xFE) {
	    switch (c * 0x100 + cc) {
	    case 0xC7CF:
	      p->by_char += 2;
	    case 0xC7D1:
	      p->by_char += 2;
	    default:
	      break;
	    }

	    p->by_char += 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  break;
	}
      }
      else
	p->by_encode -= 1;
    }

  p->processed = i;
}

size_t
mb_cs_judge_kr(mb_cs_detector_t *p)
{
  mb_cs_judge_euc_kr(&p->stat[mb_cs_detect_kr_EUC], p->bag, p->end);
  mb_cs_judge_euc_kr(&p->stat[mb_cs_detect_kr_JOHAB], p->bag, p->end);
  mb_cs_judge_euc_kr(&p->stat[mb_cs_detect_kr_UTF8], p->bag, p->end);
  mb_cs_judge_euc_kr(&p->stat[mb_cs_detect_kr_UHANG], p->bag, p->end);
  return MB_CS_DETECT_CHOICEMAX;
}

char *
mb_cs_setup_kr(mb_cs_detector_t *p, size_t i, size_t same)
{
  char *cs = p->private;

  if ((p->stat[i].by_encode || p->stat[i].by_char) && (!same || !cs))
    switch (i) {
    case mb_cs_detect_kr_EUC:
      cs = "euc-kr";
      break;
    case mb_cs_detect_kr_JOHAB:
      cs = "x-johab";
      break;
    case mb_cs_detect_kr_UTF8:
      cs = "utf-8";
      break;
    case mb_cs_detect_kr_UHANG:
      cs = "x-unified-hangul";
      break;
    default:
      break;
    }

  mb_charset_to_esc(cs, p->orig);
  return cs;
}

#ifdef USE_UCS

void
mb_conv_ucs_to_kr(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_94x94, 0x43):
	case MB_ESC_ENC(mb_94x94, 0x4E):
	  ch->c = MB_WORD_DEC_C(*p);
	  ch->set = mb_94x94;
	  ch->fc = MB_WORD_DEC_FC(*p);
	  ch->gn = mb_G0;
	  ch->sn = mb_SL;
	  return;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p)) {
	  mb_ucs_to_isoc(pool, ch);
	  return;
	}
      }
    }
  }
}

void
mb_conv_ucs_to_johab(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_128, MB_JOHABLL_FC):
	case MB_ESC_ENC(mb_128, MB_JOHABLR_FC):
	case MB_ESC_ENC(mb_128, MB_JOHABH_FC):
	  ch->c = MB_WORD_DEC_C(*p);
	  ch->set = mb_128;
	  ch->fc = MB_WORD_DEC_FC(*p);
	  ch->gn = mb_G1;
	  ch->sn = mb_SR;
	  return;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p))
	  return;
      }
    }
  }
}

void
mb_conv_ucs_to_uhang(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_128, MB_UHANGLL_FC):
	case MB_ESC_ENC(mb_128, MB_UHANGLR_FC):
	case MB_ESC_ENC(mb_128, MB_UHANGH_FC):
	  ch->c = MB_WORD_DEC_C(*p);
	  ch->set = mb_128;
	  ch->fc = MB_WORD_DEC_FC(*p);
	  ch->gn = mb_G1;
	  ch->sn = mb_SR;
	  return;
	case MB_ESC_ENC(mb_94x94, 0x43):
	  ch->c = MB_WORD_DEC_C(*p);
	  ch->set = mb_128;
	  ch->fc = MB_UHANGH_FC;
	  ch->gn = mb_G1;
	  ch->sn = mb_SR;
	  return;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p))
	  return;
      }
    }
  }
}

#endif
