#include "ja.h"

void
mb_sjis_convg0sl(mb_char_t *ch, mb_info_t *info)
{
  switch (ch->fc & MB_ESC_FC_MASK) {
  case MB_SJIS_FC & MB_ESC_FC_MASK:
    if (ch->c < 0x60) {
      ch->set = mb_94_0;
      ch->fc = 0x49 & MB_ESC_FC_MASK;
    }
    else if ((info->flag & MB_FLAG_JISX_PREFERENCE) == MB_FLAG_PREFER_JISX0213 ||
	     !(mb_get_jis1flag(ch->c) & MB_IN_JISX0208)) {
      ch->set = mb_94x94;
      ch->fc = 0x4F & MB_ESC_FC_MASK;
    }
    else {
      ch->set = mb_94x94;
      ch->fc = 0x42 & MB_ESC_FC_MASK;
    }

    break;
  case MB_SJIS0213_FC & MB_ESC_FC_MASK:
    ch->set = mb_94x94;
    ch->fc = 0x50 & MB_ESC_FC_MASK;
    break;
  default:
    return;
  }

  ch->gn = mb_G0;
  ch->sn = mb_SL;
}

int
mb_sjis_enc(int c, mb_info_t *info)
{
  mb_char_t ch;

  ch.fc = MB_SJIS_FC;

  if (c >= 0xA1 && c <= 0xDF)
    c -= 0xA0;
  else {
    int off = 1, cc, ccc;

    if (c >= 0x81 && c <= 0x9F)
      ccc = (c - 0x81) * 2 + 0x21 - 0x20;
    else if (c >= 0xE0 && c <= 0xEF)
      ccc = (c - 0xE0 + 0xA0 - 0x81) * 2 + 0x21 - 0x20;
    else if (c >= 0xF0 && c <= 0xFC) {
      switch (c) {
      case 0xF0:
	off = 1 + 0x07;
      case 0xF1:
	ccc = (c - 0xF0) * 2 + 0x21 - 0x20;
	break;
      case 0xF2:
	ccc = (c - 0xF0) * 2 + 0x21 - 0x20;
	off = 1 + 0x06;
	break;
      case 0xF3:
	off = 1 + 0x3E;
      case 0xF4:
	ccc = (c - 0xF2) * 2 + 0x2B - 0x20;
	break;
      default:
	ccc = (c - 0xF5) * 2 + 0x6F - 0x20;
	break;
      }

      ch.fc = MB_SJIS0213_FC;
    }
    else
      goto bad_gr;

    if ((cc = mb_call_getc(info)) == EOF)
      goto bad_gr;

    if (cc >= 0x40 && cc <= 0x7E)
      c = ccc * 0x60 + cc - 0x40 + 0x21 - 0x20;
    else if (cc >= 0x80 && cc <= 0x9E)
      c = ccc * 0x60 + cc - 0x80 + 0x7F - 0x40 + 0x21 - 0x20;
    else if (cc >= 0x9F && cc <= 0xFC)
      c = (ccc + off) * 0x60 + cc - 0x9F + 0x21 - 0x20;
    else {
      char temp[1];

      temp[0] = cc;
      mb_fill_inbuf(info, temp, 1);
      goto bad_gr;
    }
  }

  goto end;
bad_gr:
  ch.fc = MB_UNKNOWN_FC;
end:
  ch.c = c;
  ch.set = mb_128;
  ch.gn = mb_G1;
  ch.sn = mb_SR;
  return mb_utf8_badenc(&ch, info);
}

size_t
mb_sjis_dec(int c, int fc, char *buf)
{
  size_t e;
  int c1, c2, off;

  switch (fc) {
  case MB_SJIS_FC & MB_ESC_FC_MASK:
    if (c < 0x40) {
      buf[0] = c + 0xA0;
      e = 1;
    }
    else {
      c1 = c / 0x60;
      c2 = c % 0x60;

      if (c1 & 1) {
	c2 += -1 + 0x40;

	if (c2 <= 0x7E)
	  buf[1] = c2;
	else
	  buf[1] = c2 - 0x7F + 0x80;
      }
      else
	buf[1] = c2 - 1 + 0x9F;

      buf[0] = (c1 - 1) / 2 + 0x81;

      if ((unsigned char)buf[0] >= 0xA0)
	buf[0] += - 0xA0 + 0xE0;

      e = 2;
    }

    break;
  case MB_SJIS0213_FC & MB_ESC_FC_MASK:
    c1 = c / 0x60;
    c2 = c % 0x60;
    off = 1;

    switch (c1) {
    case 0x08:
      off = 1 + 0x06;
      break;
    case 0x0C:
    case 0x0D:
    case 0x0E:
      off = 1 + 0x0A;
      break;
    default:
      if (c1 >= 0x4E && c1 <= 0x7E)
	off = 1 + 0x4C;

      break;
    }

    if (c1 & 1) {
      if (c2 < 0x40)
	buf[1] = c2 - 1 + 0x40;
      else
	buf[1] = c2 - 1 - 0x40 + 0x80;
    }
    else
      buf[1] = c2 - 1 + 0x9F;

    buf[0] = (c1 - off) / 2 + 0xF0;
    e = 2;
    break;
  default:
    e = 0;
    break;
  }

  return e;
}

size_t
mb_sjis_width(mb_char_t *ch)
{
  return ((ch->fc & MB_ESC_FC_MASK) == (MB_SJIS_FC & MB_ESC_FC_MASK) && ch->c < 0x60) ? 1 : 2;
}

void
mb_conv_euc_jp(mb_char_t *ch, mb_info_t *info)
{
  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x42 & MB_ESC_FC_MASK:
    case 0x4F & MB_ESC_FC_MASK:
      ch->gn = mb_G1;
      ch->sn = mb_SR;
      break;
    case 0x44 & MB_ESC_FC_MASK:
    case 0x50 & MB_ESC_FC_MASK:
      ch->gn = mb_G3;
      ch->sn = mb_SSR;
    default:
      break;
    }

    break;
  case mb_94_0:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x42 & MB_ESC_FC_MASK:
      ch->gn = mb_G0;
      ch->sn = mb_SL;
      break;
    case 0x49 & MB_ESC_FC_MASK:
      ch->gn = mb_G2;
      ch->sn = mb_SSR;
      break;
    }

    break;
  case mb_128:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case MB_SJIS_FC & MB_ESC_FC_MASK:
      if (ch->c < 0x60) {
	ch->set = mb_94_0;
	ch->fc = 0x49 & MB_ESC_FC_MASK;
	ch->gn = mb_G2;
	ch->sn = mb_SSR;
      }
      else {
	ch->set = mb_94x94;
	ch->fc = 0x42 & MB_ESC_FC_MASK;
	ch->gn = mb_G1;
	ch->sn = mb_SR;
      }

      break;
    case MB_SJIS0213_FC & MB_ESC_FC_MASK:
      ch->set = mb_94x94;
      ch->fc = 0x50 & MB_ESC_FC_MASK;
      ch->gn = mb_G1;
      ch->sn = mb_SR;
      break;
    }
  default:
    break;
  }
}

void
mb_conv_sjis(mb_char_t *ch, mb_info_t *info)
{
  switch (ch->set) {
  case mb_94x94:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x42 & MB_ESC_FC_MASK:
    case 0x4F & MB_ESC_FC_MASK:
      ch->set = mb_128;
      ch->fc = MB_SJIS_FC & MB_ESC_FC_MASK;
      break;
    case 0x50 & MB_ESC_FC_MASK:
      ch->set = mb_128;
      ch->fc = MB_SJIS0213_FC & MB_ESC_FC_MASK;
    default:
      break;
    }

    break;
  case mb_94_0:
    switch (ch->fc & MB_ESC_FC_MASK) {
    case 0x49 & MB_ESC_FC_MASK:
      ch->set = mb_128;
      ch->fc = MB_SJIS_FC & MB_ESC_FC_MASK;
    default:
      break;
    }

  default:
    break;
  }
}

void
mb_cs_judge_euc_jp(mb_cs_detector_stat_t *p, const char *bag, size_t e)
{
  size_t i;
  int c;

  for (i = p->processed ; i < e ;)
    if ((c = (unsigned char)bag[i++]) & 0x80) {
      if (c == 0x8E || (c >= 0xA1 && c <= 0xFE)) {
	if (i < e) {
	  if ((unsigned char)bag[i] >= 0xA1 && (unsigned char)bag[i] <= 0xFE) {
	    p->by_char += 2;

	    switch (c = c * 0x100 + (unsigned char)bag[i++]) {
	    case 0xA1A2:
	    case 0xA1A3:
	    case 0xA1A4:
	    case 0xA1A5:
	      p->by_char += 6; /* kutenn & toutenn */
	      break;
	    default:
	      if (c >= 0xA4A1 && c <= 0xA4F3)
		p->by_char += 4; /* hiragana */
	      else if (c >= 0xA5A1 && c <= 0xA5A6)
		p->by_char += 2; /* katakana */

	      break;
	    }
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  goto end_euc;
	}
      }
      else if (c == 0x8F)
	switch (e - i) {
	case 0:
	  if (--i <= p->processed) {
	    p->by_encode -= 1;
	    ++i;
	  }

	  goto end_euc;
	case 1:
	  if ((unsigned char)bag[i] >= 0xA1 && (unsigned char)bag[i] <= 0xFE) {
	    if (--i <= p->processed) {
	      p->by_encode -= 1;
	      ++i;
	    }
	  }
	  else
	    p->by_encode -= 1;

	  goto end_euc;
	default:
	  if ((unsigned char)bag[i] >= 0xA1 && (unsigned char)bag[i] <= 0xFE &&
	      (unsigned char)bag[i + 1] >= 0xA1 && (unsigned char)bag[i + 1] <= 0xFE) {
	    i += 2;
	    p->by_char += 3;
	  }
	  else
	    p->by_encode -= 1;
	}
      else
	p->by_encode -= 1;
    }
end_euc:
  p->processed = i;
}

void
mb_cs_judge_shift_jis(mb_cs_detector_stat_t *p, const char *bag, size_t e)
{
  size_t i;
  int c, cc;

  for (i = p->processed ; i < e ;)
    if ((c = (unsigned char)bag[i++]) & 0x80) {
      if (c >= 0xA1 && c <= 0xDF)
	p->by_char += 1;
      else if ((c >= 0x81 && c <= 0x9F) || (c >= 0xE0 && c <= 0xEF)) {
	if (i < e) {
	  if (((cc = (unsigned char)bag[i]) >= 0x40 && cc <= 0x7E) ||
	      (cc >= 0x80 && cc <= 0xFC)) {
	    switch (c = c * 0x100 + cc) {
	    case 0x8141:
	    case 0x8142:
	    case 0x8143:
	    case 0x8144:
	      p->by_char += 6;
	      break;
	    default:
	      if (c >= 0x829F && c <= 0x82F1)
		p->by_char += 4; /* hiragana */
	      else if (c >= 0x8340 && c <= 0x8396)
		p->by_char += 2; /* katakana */

	      break;
	    }

	    p->by_char += cc <= 0x7E ? 1 : 2;
	    ++i;
	  }
	  else
	    p->by_encode -= 1;
	}
	else {
	  if (--i <= p->processed)
	    ++i;

	  break;
	}
      }
    }

  p->processed = i;
}

size_t
mb_cs_judge_ja(mb_cs_detector_t *p)
{
  mb_cs_judge_euc_jp(&p->stat[mb_cs_detect_ja_EUC], p->bag, p->end);
  mb_cs_judge_shift_jis(&p->stat[mb_cs_detect_ja_SJIS], p->bag, p->end);
  mb_cs_judge_utf8(&p->stat[mb_cs_detect_ja_UTF8], p->bag, p->end);
  return MB_CS_DETECT_CHOICEMAX;
}

char *
mb_cs_setup_ja(mb_cs_detector_t *p, size_t i, size_t same)
{
  char *cs = p->private;

  if ((p->stat[i].by_encode || p->stat[i].by_char) && (!same || !cs))
    switch (i) {
    case mb_cs_detect_ja_EUC:
      cs = "euc-jp";
      break;
    case mb_cs_detect_ja_SJIS:
      cs = "shift_jis";
      break;
    /* case mb_cs_detect_ja_UTF8: */
    default:
      cs = "utf-8";
      break;
    }

  mb_charset_to_esc(cs, p->orig);
  return cs;
}

#ifdef USE_UCS

void
mb_conv_ucs_to_ja(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set == mb_128 && (ch->fc & MB_ESC_FC_MASK) == (0x47 & MB_ESC_FC_MASK)) {
    int *pool = mb_ucs_to_isov(ch->c);

    if (pool) {
      int *jisx0208 = NULL;
      int *jisx0212 = NULL;
      int *jisx0213_1 = NULL;
      int *jisx0213_2 = NULL;
      int *jisx0201_r = NULL;
      int *jisx0201_l = NULL;
      int *p;

      for (p = pool ;; ++p) {
	switch (MB_WORD_DEC_ESC(*p)) {
	case MB_ESC_ENC(mb_94x94, 0x42):
	  jisx0208 = p;
	  break;
	case MB_ESC_ENC(mb_94x94, 0x44):
	  jisx0212 = p;
	  break;
	case MB_ESC_ENC(mb_94x94, 0x4F):
	  jisx0213_1 = p;
	  break;
	case MB_ESC_ENC(mb_94x94, 0x50):
	  jisx0213_2 = p;
	  break;
	case MB_ESC_ENC(mb_94_0, 0x49):
	  jisx0201_r = p;
	  break;
	case MB_ESC_ENC(mb_94_0, 0x4A):
	  jisx0201_l = p;
	default:
	  break;
	}

	if (MB_U2I_ISLAST(*p))
	  break;
      }

      p = NULL;

      switch (info->flag & MB_FLAG_JISX_PREFERENCE) {
      case MB_FLAG_PREFER_JISX0213:
	if (jisx0213_1)
	  p = jisx0213_1;
	else if (jisx0213_2)
	  p = jisx0213_2;
	else if (jisx0208)
	  p = jisx0208;
	else if (jisx0212)
	  p = jisx0212;
	else if (jisx0201_r)
	  p = jisx0201_r;
	else if (jisx0201_l)
	  p = jisx0201_l;

	break;
      case MB_FLAG_DONTPREFER_JISX0213:
	if (jisx0208)
	  p = jisx0208;
	else if (jisx0212)
	  p = jisx0212;
	else if (jisx0201_r)
	  p = jisx0201_r;
	else if (jisx0201_l)
	  p = jisx0201_l;
	else if (jisx0213_1)
	  p = jisx0213_1;
	else if (jisx0213_2)
	  p = jisx0213_2;

	break;
      default:
	if (jisx0208)
	  p = jisx0208;
	else if (jisx0212)
	  p = jisx0212;
	else if (jisx0213_1)
	  p = jisx0213_1;
	else if (jisx0213_2)
	  p = jisx0213_2;
	else if (jisx0201_r)
	  p = jisx0201_r;
	else if (jisx0201_l)
	  p = jisx0201_l;

	break;
      }

      if (p) {
	ch->c = MB_WORD_DEC_C(*p);
	ch->set = MB_WORD_DEC_SET(*p);
	ch->fc = MB_WORD_DEC_FC(*p);
	ch->gn = mb_G0;
	ch->sn = mb_SL;
      }
      else
	mb_ucs_to_isoc(pool, ch);
    }
  }
}

#endif
