/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  statusbar.cc - GtkStatusbar C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "statusbar.h"
#include "private/statusbar_p.h"

using namespace Inti;

/*  Gtk::Statusbar
 */

Gtk::Statusbar::Statusbar(GtkStatusbar *statusbar, bool reference) 
: HBox((GtkHBox*)statusbar, reference)
{
}

Gtk::Statusbar::Statusbar() 
: HBox((GtkHBox*)StatusbarClass::create())
{
}

Gtk::Statusbar::~Statusbar()
{
}

GtkStatusbarClass*
Gtk::Statusbar::gtk_statusbar_class() const 
{
	return get_class<GtkStatusbarClass>();
}
	
Gtk::Statusbar::operator GtkStatusbar* () const 
{ 
	return this ? gtk_statusbar() : 0; 
}

unsigned int
Gtk::Statusbar::get_context_id(const String& context_description) const
{
	return gtk_statusbar_get_context_id(gtk_statusbar(), context_description.c_str());
}

unsigned int
Gtk::Statusbar::push(const String& text, unsigned int context_id)
{
	return gtk_statusbar_push(gtk_statusbar(), context_id, text.c_str());
}

void 
Gtk::Statusbar::pop(unsigned int context_id)
{
	gtk_statusbar_pop(gtk_statusbar(), context_id);
}

bool 
Gtk::Statusbar::get_has_resize_grip() const
{
	return gtk_statusbar_get_has_resize_grip(gtk_statusbar());
}	

void 
Gtk::Statusbar::remove(unsigned int context_id, unsigned int message_id)
{
	gtk_statusbar_remove(gtk_statusbar(), context_id, message_id);
}

void 
Gtk::Statusbar::set_has_resize_grip(bool setting)
{
	gtk_statusbar_set_has_resize_grip(gtk_statusbar(), setting);
}

/*  Gtk::StatusbarClass
 */

void
Gtk::StatusbarClass::init(GtkStatusbarClass *g_class)
{
	HBoxClass::init((GtkHBoxClass*)g_class);
	g_class->text_pushed = &text_pushed_proxy;
	g_class->text_popped = &text_popped_proxy;
}

GType
Gtk::StatusbarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_STATUSBAR, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::StatusbarClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::StatusbarClass::text_pushed_proxy(GtkStatusbar *statusbar, guint context_id, const gchar *text)
{
	Statusbar *tmp_statusbar = G::Object::pointer<Statusbar>(statusbar);
	if (tmp_statusbar)
	{
		String tmp_text(text);
		tmp_statusbar->on_text_pushed(context_id, tmp_text);
	}
	else
	{
		GtkStatusbarClass *tmp_class = GTK_STATUSBAR_GET_CLASS(statusbar);
		GtkStatusbarClass *g_class = G::TypeInstance::class_peek_parent<GtkStatusbarClass>(tmp_class);
		if (g_class->text_pushed)
			g_class->text_pushed(statusbar, context_id, text);
	}
}

void
Gtk::StatusbarClass::text_popped_proxy(GtkStatusbar *statusbar, guint context_id, const gchar *text)
{
	Statusbar *tmp_statusbar = G::Object::pointer<Statusbar>(statusbar);
	if (tmp_statusbar)
	{
		String tmp_text(text);
		tmp_statusbar->on_text_popped(context_id, tmp_text);
	}
	else
	{
		GtkStatusbarClass *tmp_class = GTK_STATUSBAR_GET_CLASS(statusbar);
		GtkStatusbarClass *g_class = G::TypeInstance::class_peek_parent<GtkStatusbarClass>(tmp_class);
		if (g_class->text_popped)
			g_class->text_popped(statusbar, context_id, text);
	}
}

/*  Signal handlers
 */

void
Gtk::Statusbar::on_text_pushed(unsigned int context_id, const String& text)
{
	GtkStatusbarClass *g_class = class_peek_parent<GtkStatusbarClass>(gtk_statusbar_class());
	if (g_class->text_pushed)
		g_class->text_pushed(gtk_statusbar(), context_id, text.c_str());
}

void
Gtk::Statusbar::on_text_popped(unsigned int context_id, const String& text)
{
	GtkStatusbarClass *g_class = class_peek_parent<GtkStatusbarClass>(gtk_statusbar_class());
	if (g_class->text_popped)
		g_class->text_popped(gtk_statusbar(), context_id, text.c_str());
}

/*  Signals
 */

const Gtk::Statusbar::TextPushedSignalType Gtk::Statusbar::text_pushed_signal("text_pushed");

const Gtk::Statusbar::TextPoppedSignalType Gtk::Statusbar::text_popped_signal("text_popped");

