/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  separatormenuitem.cc - GtkSeparatorMenuItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "separatormenuitem.h"
#include "private/separatormenuitem_p.h"

using namespace Inti;

/*  Gtk::SeparatorMenuItem
 */

Gtk::SeparatorMenuItem::SeparatorMenuItem(GtkSeparatorMenuItem *menu_item, bool reference) 
: MenuItem((GtkMenuItem*)menu_item, reference)
{
}
	
Gtk::SeparatorMenuItem::SeparatorMenuItem()
: MenuItem((GtkMenuItem*)SeparatorMenuItemClass::create())
{
}

Gtk::SeparatorMenuItem::~SeparatorMenuItem()
{
}

GtkSeparatorMenuItemClass* 
Gtk::SeparatorMenuItem::gtk_separator_menu_item_class() const 
{ 
	return get_class<GtkSeparatorMenuItemClass>(); 
}
	
Gtk::SeparatorMenuItem::operator GtkSeparatorMenuItem* () const 
{ 
	return this ? gtk_separator_menu_item() : 0; 
}
	
/*  Gtk::SeparatorMenuItemClass
 */

void
Gtk::SeparatorMenuItemClass::init(GtkSeparatorMenuItemClass *g_class)
{
	MenuItemClass::init((GtkMenuItemClass*)g_class);
}

GType
Gtk::SeparatorMenuItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SEPARATOR_MENU_ITEM, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::SeparatorMenuItemClass::create()
{
	return g_object_new(get_type(), 0);
}

