/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  optionmenu.cc - GtkOptionMenu C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "optionmenu.h"
#include "private/optionmenu_p.h"
#include "menu.h"
#include "menuitem.h"

using namespace Inti;

/*  Gtk::OptionMenu
 */

Gtk::OptionMenu::OptionMenu(GtkOptionMenu *option_menu, bool reference)
: Button((GtkButton*)option_menu, reference)
{
}

Gtk::OptionMenu::OptionMenu()
: Button((GtkButton*)OptionMenuClass::create())
{
}

Gtk::OptionMenu::OptionMenu(Menu& menu, unsigned int index)
: Button((GtkButton*)OptionMenuClass::create())
{
	set_menu(menu);
	set_history(index);
}

Gtk::OptionMenu::~OptionMenu()
{
}

GtkOptionMenuClass*
Gtk::OptionMenu::gtk_option_menu_class() const 
{ 
	return get_class<GtkOptionMenuClass>(); 
}

Gtk::OptionMenu::operator GtkOptionMenu* () const 
{ 
	return this ? gtk_option_menu() : 0; 
}
	
Gtk::Menu*
Gtk::OptionMenu::get_menu() const
{
	return G::Object::wrap<Menu>((GtkMenu*)gtk_option_menu_get_menu(gtk_option_menu()));
}

int
Gtk::OptionMenu::get_history() const
{
	return gtk_option_menu_get_history(gtk_option_menu());
}

void
Gtk::OptionMenu::set_menu(Menu& menu)
{
	gtk_option_menu_set_menu(gtk_option_menu(), menu.gtk_widget());
}

void
Gtk::OptionMenu::remove_menu()
{
	gtk_option_menu_remove_menu(gtk_option_menu());
}

void
Gtk::OptionMenu::set_history(unsigned int index)
{
	gtk_option_menu_set_history(gtk_option_menu(), index);
}

/*  Gtk::OptionMenuClass
 */

void
Gtk::OptionMenuClass::init(GtkOptionMenuClass *g_class)
{
	ButtonClass::init((GtkButtonClass*)g_class);
	g_class->changed = &changed_proxy;
}

GType
Gtk::OptionMenuClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_OPTION_MENU, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::OptionMenuClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::OptionMenuClass::changed_proxy(GtkOptionMenu *option_menu)
{
	OptionMenu *tmp_option_menu = G::Object::pointer<OptionMenu>(option_menu);
	if (tmp_option_menu)
		tmp_option_menu->on_changed();
	else
	{
		GtkOptionMenuClass *tmp_class = GTK_OPTION_MENU_GET_CLASS(option_menu);
		GtkOptionMenuClass *g_class = G::TypeInstance::class_peek_parent<GtkOptionMenuClass>(tmp_class);
		if (g_class->changed)
			g_class->changed(option_menu);
	}
}

/*  Signal handlers
 */

void
Gtk::OptionMenu::on_changed()
{
	GtkOptionMenuClass *g_class = class_peek_parent<GtkOptionMenuClass>(gtk_option_menu_class());
	if (g_class->changed)
		g_class->changed(gtk_option_menu());
}

/*  Properties
 */

const Gtk::OptionMenu::MenuPropertyType Gtk::OptionMenu::menu_property("menu");

/*  Signals
 */

const Gtk::OptionMenu::ChangedSignalType Gtk::OptionMenu::changed_signal("changed");

