/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  unicode.cc - gunichar C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "unicode.h"

using namespace Inti;

G::Unichar::Unichar(gunichar c)
: Base(c)
{
}
	
G::Unichar::Unichar(const Unichar& src) 
: Base(src.value_)
{
}

G::Unichar&
G::Unichar::operator=(const Unichar& src)
{ 
	value_ = src.value_;
	return *this;
}

bool
G::Unichar::is_alnum() const 
{ 
	return g_unichar_isalnum(value_);
}

bool
G::Unichar::is_alpha() const 
{ 
	return g_unichar_isalpha(value_);
}

bool
G::Unichar::is_cntrl() const 
{
	return g_unichar_iscntrl(value_);
}

bool
G::Unichar::is_digit() const
{
	return g_unichar_isdigit(value_);
}

bool
G::Unichar::is_graph() const 
{
	return g_unichar_isgraph(value_);
}

bool
G::Unichar::is_lower() const 
{
	return g_unichar_islower(value_);
}

bool
G::Unichar::is_print() const 
{ 
	return g_unichar_isprint(value_);
}

bool
G::Unichar::is_punct() const 
{ 
	return g_unichar_ispunct(value_);
}

bool
G::Unichar::is_space() const 
{
	return g_unichar_isspace(value_);
}

bool
G::Unichar::is_upper() const 
{
	return g_unichar_isupper(value_);
}

bool
G::Unichar::is_xdigit() const 
{ 
	return g_unichar_isxdigit(value_);
}

bool
G::Unichar::is_title() const 
{ 
	return g_unichar_istitle(value_);
}

bool
G::Unichar::is_defined() const 
{
	return g_unichar_isdefined(value_);
}

bool
G::Unichar::is_wide() const 
{
	return g_unichar_iswide(value_);
}

GUnicodeType 
G::Unichar::type() const 
{ 
	return g_unichar_type(value_);
}

GUnicodeBreakType 
G::Unichar::break_type() const 
{ 
	return g_unichar_break_type(value_);
}

G::Unichar
G::Unichar::upper() const 
{ 
	return g_unichar_toupper(value_);
}

G::Unichar
G::Unichar::lower() const 
{
	return g_unichar_tolower(value_);
}

G::Unichar
G::Unichar::title() const 
{ 
	return g_unichar_totitle(value_);
}

int 
G::Unichar::digit_value() const 
{ 
	return g_unichar_digit_value(value_);
}

int 
G::Unichar::xdigit_value() const 
{ 
	return g_unichar_xdigit_value(value_);
}

bool 
G::Unichar::validate() const
{ 
	return g_unichar_validate(value_);
}

