/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  document.cc - AtkDocument C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "document.h"
#include "private/document_p.h"
#include "../glib/object.h"

using namespace Inti;

/*  Atk::Document
 */

Atk::Document::~Document()
{
}
	
AtkDocumentIface* 
Atk::Document::atk_document_iface() const 
{ 
	return peek<AtkDocumentIface>(ATK_TYPE_DOCUMENT); 
}
	
Atk::Document::operator AtkDocument* () const 
{ 
	return this ? atk_document() : 0; 
}
	
String 
Atk::Document::get_document_type() const
{
	return atk_document_get_document_type(atk_document());
}

void*
Atk::Document::get_document() const
{
	return atk_document_get_document(atk_document());
}

/*  Atk::DocumentIface
 */

void
Atk::DocumentIface::init(AtkDocumentIface *g_iface)
{
	g_iface->get_document_type = &get_document_type_proxy;
	g_iface->get_document = &get_document_proxy;
}

const gchar*
Atk::DocumentIface::get_document_type_proxy(AtkDocument *document)
{
	const gchar *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(document));
	Atk::Document *tmp_document = dynamic_cast<Atk::Document*>(object);
	if (tmp_document)
		result = tmp_document->do_get_document_type();
	else
	{
		AtkDocumentIface *g_iface = static_cast<AtkDocumentIface*>(g_type_interface_peek_parent(ATK_DOCUMENT_GET_IFACE(document)));
		if (g_iface->get_document_type)
			result = g_iface->get_document_type(document);
	}
	return result;
}

gpointer
Atk::DocumentIface::get_document_proxy(AtkDocument *document)
{
	void *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(document));
	Atk::Document *tmp_document = dynamic_cast<Atk::Document*>(object);
	if (tmp_document)
		result = tmp_document->do_get_document();
	else
	{
		AtkDocumentIface *g_iface = static_cast<AtkDocumentIface*>(g_type_interface_peek_parent(ATK_DOCUMENT_GET_IFACE(document)));
		if (g_iface->get_document)
			result = g_iface->get_document(document);
	}
	return result;
}

/*  Overridable methods
 */

const char*
Atk::Document::do_get_document_type()
{
	const char *result = 0;
	AtkDocumentIface *g_iface = peek_parent<AtkDocumentIface>(atk_document_iface());
	if (g_iface->get_document_type)
		result = g_iface->get_document_type(atk_document());
	return result;
}

void*
Atk::Document::do_get_document()
{
	void *result = 0;
	AtkDocumentIface *g_iface = peek_parent<AtkDocumentIface>(atk_document_iface());
	if (g_iface->get_document)
		result = g_iface->get_document(atk_document());
	return result;
}

