/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TCPService.cc,v 1.3 2001/12/19 12:47:12 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <fwbuilder/TCPService.hh>

#include <fwbuilder/XMLTools.hh>

using namespace libfwbuilder;

const char *TCPService::TYPENAME={"TCPService"};

TCPService::TCPService()  
{
}

TCPService::~TCPService() {}

void TCPService::fromXML(xmlNodePtr root)
{
    FWObject::fromXML(root);

    const char *n;

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("src_range_start")));
    if(n!=NULL) setStr("src_range_start", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("src_range_end")));
    if(n!=NULL) setStr("src_range_end", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("dst_range_start")));
    if(n!=NULL) setStr("dst_range_start", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("dst_range_end")));
    if(n!=NULL) setStr("dst_range_end", n);



    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("syn_flag")));
    if(n!=NULL) setStr("syn_flag", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("ack_flag")));
    if(n!=NULL) setStr("ack_flag", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("fin_flag")));
    if(n!=NULL) setStr("fin_flag", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("rst_flag")));
    if(n!=NULL) setStr("rst_flag", n);
}









